package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetTransitGatewayPrefixListReferencesResponse(
    transitGatewayPrefixListReferences: Option[
      Iterable[zio.aws.ec2.model.TransitGatewayPrefixListReference]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetTransitGatewayPrefixListReferencesResponse = {
    import GetTransitGatewayPrefixListReferencesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetTransitGatewayPrefixListReferencesResponse
      .builder()
      .optionallyWith(
        transitGatewayPrefixListReferences.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitGatewayPrefixListReferences)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesResponse.ReadOnly =
    zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesResponse
      .wrap(buildAwsValue())
}
object GetTransitGatewayPrefixListReferencesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetTransitGatewayPrefixListReferencesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesResponse =
      zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesResponse(
        transitGatewayPrefixListReferences.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def transitGatewayPrefixListReferences: Option[
      List[zio.aws.ec2.model.TransitGatewayPrefixListReference.ReadOnly]
    ]
    def nextToken: Option[String]
    def getTransitGatewayPrefixListReferences: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TransitGatewayPrefixListReference.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "transitGatewayPrefixListReferences",
      transitGatewayPrefixListReferences
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetTransitGatewayPrefixListReferencesResponse
  ) extends zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesResponse.ReadOnly {
    override val transitGatewayPrefixListReferences: Option[
      List[zio.aws.ec2.model.TransitGatewayPrefixListReference.ReadOnly]
    ] = scala
      .Option(impl.transitGatewayPrefixListReferences())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TransitGatewayPrefixListReference.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetTransitGatewayPrefixListReferencesResponse
  ): zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesResponse.ReadOnly =
    new Wrapper(impl)
}
