package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FastLaunchSnapshotConfigurationRequest(
    targetResourceCount: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FastLaunchSnapshotConfigurationRequest = {
    import FastLaunchSnapshotConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FastLaunchSnapshotConfigurationRequest
      .builder()
      .optionallyWith(
        targetResourceCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.targetResourceCount)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.FastLaunchSnapshotConfigurationRequest.ReadOnly =
    zio.aws.ec2.model.FastLaunchSnapshotConfigurationRequest
      .wrap(buildAwsValue())
}
object FastLaunchSnapshotConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FastLaunchSnapshotConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FastLaunchSnapshotConfigurationRequest =
      zio.aws.ec2.model.FastLaunchSnapshotConfigurationRequest(
        targetResourceCount.map(value => value)
      )
    def targetResourceCount: Option[Integer]
    def getTargetResourceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("targetResourceCount", targetResourceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FastLaunchSnapshotConfigurationRequest
  ) extends zio.aws.ec2.model.FastLaunchSnapshotConfigurationRequest.ReadOnly {
    override val targetResourceCount: Option[Integer] = scala
      .Option(impl.targetResourceCount())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FastLaunchSnapshotConfigurationRequest
  ): zio.aws.ec2.model.FastLaunchSnapshotConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
