package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.LaunchTemplateId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FastLaunchLaunchTemplateSpecificationRequest(
    launchTemplateId: Option[LaunchTemplateId] = None,
    launchTemplateName: Option[String] = None,
    version: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FastLaunchLaunchTemplateSpecificationRequest = {
    import FastLaunchLaunchTemplateSpecificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FastLaunchLaunchTemplateSpecificationRequest
      .builder()
      .optionallyWith(
        launchTemplateId.map(value =>
          LaunchTemplateId.unwrap(value): java.lang.String
        )
      )(_.launchTemplateId)
      .optionallyWith(launchTemplateName.map(value => value: java.lang.String))(
        _.launchTemplateName
      )
      .version(version: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.FastLaunchLaunchTemplateSpecificationRequest.ReadOnly =
    zio.aws.ec2.model.FastLaunchLaunchTemplateSpecificationRequest
      .wrap(buildAwsValue())
}
object FastLaunchLaunchTemplateSpecificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FastLaunchLaunchTemplateSpecificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.FastLaunchLaunchTemplateSpecificationRequest =
      zio.aws.ec2.model.FastLaunchLaunchTemplateSpecificationRequest(
        launchTemplateId.map(value => value),
        launchTemplateName.map(value => value),
        version
      )
    def launchTemplateId: Option[LaunchTemplateId]
    def launchTemplateName: Option[String]
    def version: String
    def getLaunchTemplateId: ZIO[Any, AwsError, LaunchTemplateId] =
      AwsError.unwrapOptionField("launchTemplateId", launchTemplateId)
    def getLaunchTemplateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
    def getVersion: ZIO[Any, Nothing, String] = ZIO.succeed(version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FastLaunchLaunchTemplateSpecificationRequest
  ) extends zio.aws.ec2.model.FastLaunchLaunchTemplateSpecificationRequest.ReadOnly {
    override val launchTemplateId: Option[LaunchTemplateId] = scala
      .Option(impl.launchTemplateId())
      .map(value => zio.aws.ec2.model.primitives.LaunchTemplateId(value))
    override val launchTemplateName: Option[String] =
      scala.Option(impl.launchTemplateName()).map(value => value: String)
    override val version: String = impl.version(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FastLaunchLaunchTemplateSpecificationRequest
  ): zio.aws.ec2.model.FastLaunchLaunchTemplateSpecificationRequest.ReadOnly =
    new Wrapper(impl)
}
