package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EnclaveOptionsRequest(enabled: Option[Boolean] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnclaveOptionsRequest = {
    import EnclaveOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnclaveOptionsRequest
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EnclaveOptionsRequest.ReadOnly =
    zio.aws.ec2.model.EnclaveOptionsRequest.wrap(buildAwsValue())
}
object EnclaveOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnclaveOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnclaveOptionsRequest =
      zio.aws.ec2.model.EnclaveOptionsRequest(enabled.map(value => value))
    def enabled: Option[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnclaveOptionsRequest
  ) extends zio.aws.ec2.model.EnclaveOptionsRequest.ReadOnly {
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnclaveOptionsRequest
  ): zio.aws.ec2.model.EnclaveOptionsRequest.ReadOnly = new Wrapper(impl)
}
