package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EbsInfo(
    ebsOptimizedSupport: Option[zio.aws.ec2.model.EbsOptimizedSupport] = None,
    encryptionSupport: Option[zio.aws.ec2.model.EbsEncryptionSupport] = None,
    ebsOptimizedInfo: Option[zio.aws.ec2.model.EbsOptimizedInfo] = None,
    nvmeSupport: Option[zio.aws.ec2.model.EbsNvmeSupport] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.EbsInfo = {
    import EbsInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EbsInfo
      .builder()
      .optionallyWith(ebsOptimizedSupport.map(value => value.unwrap))(
        _.ebsOptimizedSupport
      )
      .optionallyWith(encryptionSupport.map(value => value.unwrap))(
        _.encryptionSupport
      )
      .optionallyWith(ebsOptimizedInfo.map(value => value.buildAwsValue()))(
        _.ebsOptimizedInfo
      )
      .optionallyWith(nvmeSupport.map(value => value.unwrap))(_.nvmeSupport)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EbsInfo.ReadOnly =
    zio.aws.ec2.model.EbsInfo.wrap(buildAwsValue())
}
object EbsInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.EbsInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EbsInfo = zio.aws.ec2.model.EbsInfo(
      ebsOptimizedSupport.map(value => value),
      encryptionSupport.map(value => value),
      ebsOptimizedInfo.map(value => value.asEditable),
      nvmeSupport.map(value => value)
    )
    def ebsOptimizedSupport: Option[zio.aws.ec2.model.EbsOptimizedSupport]
    def encryptionSupport: Option[zio.aws.ec2.model.EbsEncryptionSupport]
    def ebsOptimizedInfo: Option[zio.aws.ec2.model.EbsOptimizedInfo.ReadOnly]
    def nvmeSupport: Option[zio.aws.ec2.model.EbsNvmeSupport]
    def getEbsOptimizedSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.EbsOptimizedSupport] =
      AwsError.unwrapOptionField("ebsOptimizedSupport", ebsOptimizedSupport)
    def getEncryptionSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.EbsEncryptionSupport] =
      AwsError.unwrapOptionField("encryptionSupport", encryptionSupport)
    def getEbsOptimizedInfo
        : ZIO[Any, AwsError, zio.aws.ec2.model.EbsOptimizedInfo.ReadOnly] =
      AwsError.unwrapOptionField("ebsOptimizedInfo", ebsOptimizedInfo)
    def getNvmeSupport: ZIO[Any, AwsError, zio.aws.ec2.model.EbsNvmeSupport] =
      AwsError.unwrapOptionField("nvmeSupport", nvmeSupport)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EbsInfo
  ) extends zio.aws.ec2.model.EbsInfo.ReadOnly {
    override val ebsOptimizedSupport
        : Option[zio.aws.ec2.model.EbsOptimizedSupport] = scala
      .Option(impl.ebsOptimizedSupport())
      .map(value => zio.aws.ec2.model.EbsOptimizedSupport.wrap(value))
    override val encryptionSupport
        : Option[zio.aws.ec2.model.EbsEncryptionSupport] = scala
      .Option(impl.encryptionSupport())
      .map(value => zio.aws.ec2.model.EbsEncryptionSupport.wrap(value))
    override val ebsOptimizedInfo
        : Option[zio.aws.ec2.model.EbsOptimizedInfo.ReadOnly] = scala
      .Option(impl.ebsOptimizedInfo())
      .map(value => zio.aws.ec2.model.EbsOptimizedInfo.wrap(value))
    override val nvmeSupport: Option[zio.aws.ec2.model.EbsNvmeSupport] = scala
      .Option(impl.nvmeSupport())
      .map(value => zio.aws.ec2.model.EbsNvmeSupport.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EbsInfo
  ): zio.aws.ec2.model.EbsInfo.ReadOnly = new Wrapper(impl)
}
