package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisassociateClientVpnTargetNetworkResponse(
    associationId: Option[String] = None,
    status: Option[zio.aws.ec2.model.AssociationStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkResponse = {
    import DisassociateClientVpnTargetNetworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkResponse
      .builder()
      .optionallyWith(associationId.map(value => value: java.lang.String))(
        _.associationId
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateClientVpnTargetNetworkResponse.ReadOnly =
    zio.aws.ec2.model.DisassociateClientVpnTargetNetworkResponse
      .wrap(buildAwsValue())
}
object DisassociateClientVpnTargetNetworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DisassociateClientVpnTargetNetworkResponse =
      zio.aws.ec2.model.DisassociateClientVpnTargetNetworkResponse(
        associationId.map(value => value),
        status.map(value => value.asEditable)
      )
    def associationId: Option[String]
    def status: Option[zio.aws.ec2.model.AssociationStatus.ReadOnly]
    def getAssociationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.AssociationStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkResponse
  ) extends zio.aws.ec2.model.DisassociateClientVpnTargetNetworkResponse.ReadOnly {
    override val associationId: Option[String] =
      scala.Option(impl.associationId()).map(value => value: String)
    override val status: Option[zio.aws.ec2.model.AssociationStatus.ReadOnly] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.ec2.model.AssociationStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateClientVpnTargetNetworkResponse
  ): zio.aws.ec2.model.DisassociateClientVpnTargetNetworkResponse.ReadOnly =
    new Wrapper(impl)
}
