package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeInstanceEventNotificationAttributesResponse(
    instanceTagAttribute: Option[
      zio.aws.ec2.model.InstanceTagNotificationAttribute
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeInstanceEventNotificationAttributesResponse = {
    import DescribeInstanceEventNotificationAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeInstanceEventNotificationAttributesResponse
      .builder()
      .optionallyWith(instanceTagAttribute.map(value => value.buildAwsValue()))(
        _.instanceTagAttribute
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeInstanceEventNotificationAttributesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeInstanceEventNotificationAttributesResponse
      .wrap(buildAwsValue())
}
object DescribeInstanceEventNotificationAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeInstanceEventNotificationAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeInstanceEventNotificationAttributesResponse =
      zio.aws.ec2.model.DescribeInstanceEventNotificationAttributesResponse(
        instanceTagAttribute.map(value => value.asEditable)
      )
    def instanceTagAttribute
        : Option[zio.aws.ec2.model.InstanceTagNotificationAttribute.ReadOnly]
    def getInstanceTagAttribute: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceTagNotificationAttribute.ReadOnly
    ] = AwsError.unwrapOptionField("instanceTagAttribute", instanceTagAttribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceEventNotificationAttributesResponse
  ) extends zio.aws.ec2.model.DescribeInstanceEventNotificationAttributesResponse.ReadOnly {
    override val instanceTagAttribute
        : Option[zio.aws.ec2.model.InstanceTagNotificationAttribute.ReadOnly] =
      scala
        .Option(impl.instanceTagAttribute())
        .map(value =>
          zio.aws.ec2.model.InstanceTagNotificationAttribute.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceEventNotificationAttributesResponse
  ): zio.aws.ec2.model.DescribeInstanceEventNotificationAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
