package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  DescribeInstanceCreditSpecificationsMaxResults,
  InstanceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeInstanceCreditSpecificationsRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    instanceIds: Option[Iterable[InstanceId]] = None,
    maxResults: Option[DescribeInstanceCreditSpecificationsMaxResults] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsRequest = {
    import DescribeInstanceCreditSpecificationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        instanceIds.map(value =>
          value.map { item =>
            InstanceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceIds)
      .optionallyWith(
        maxResults.map(value =>
          DescribeInstanceCreditSpecificationsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeInstanceCreditSpecificationsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeInstanceCreditSpecificationsRequest
      .wrap(buildAwsValue())
}
object DescribeInstanceCreditSpecificationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeInstanceCreditSpecificationsRequest =
      zio.aws.ec2.model.DescribeInstanceCreditSpecificationsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def instanceIds: Option[List[InstanceId]]
    def maxResults: Option[DescribeInstanceCreditSpecificationsMaxResults]
    def nextToken: Option[String]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getInstanceIds: ZIO[Any, AwsError, List[InstanceId]] =
      AwsError.unwrapOptionField("instanceIds", instanceIds)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeInstanceCreditSpecificationsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsRequest
  ) extends zio.aws.ec2.model.DescribeInstanceCreditSpecificationsRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val instanceIds: Option[List[InstanceId]] = scala
      .Option(impl.instanceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.InstanceId(item)
        }.toList
      )
    override val maxResults
        : Option[DescribeInstanceCreditSpecificationsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives
          .DescribeInstanceCreditSpecificationsMaxResults(value)
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsRequest
  ): zio.aws.ec2.model.DescribeInstanceCreditSpecificationsRequest.ReadOnly =
    new Wrapper(impl)
}
