package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeInstanceAttributeResponse(
    groups: Option[Iterable[zio.aws.ec2.model.GroupIdentifier]] = None,
    blockDeviceMappings: Option[
      Iterable[zio.aws.ec2.model.InstanceBlockDeviceMapping]
    ] = None,
    disableApiTermination: Option[zio.aws.ec2.model.AttributeBooleanValue] =
      None,
    enaSupport: Option[zio.aws.ec2.model.AttributeBooleanValue] = None,
    enclaveOptions: Option[zio.aws.ec2.model.EnclaveOptions] = None,
    ebsOptimized: Option[zio.aws.ec2.model.AttributeBooleanValue] = None,
    instanceId: Option[String] = None,
    instanceInitiatedShutdownBehavior: Option[
      zio.aws.ec2.model.AttributeValue
    ] = None,
    instanceType: Option[zio.aws.ec2.model.AttributeValue] = None,
    kernelId: Option[zio.aws.ec2.model.AttributeValue] = None,
    productCodes: Option[Iterable[zio.aws.ec2.model.ProductCode]] = None,
    ramdiskId: Option[zio.aws.ec2.model.AttributeValue] = None,
    rootDeviceName: Option[zio.aws.ec2.model.AttributeValue] = None,
    sourceDestCheck: Option[zio.aws.ec2.model.AttributeBooleanValue] = None,
    sriovNetSupport: Option[zio.aws.ec2.model.AttributeValue] = None,
    userData: Option[zio.aws.ec2.model.AttributeValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeResponse = {
    import DescribeInstanceAttributeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeResponse
      .builder()
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(
        disableApiTermination.map(value => value.buildAwsValue())
      )(_.disableApiTermination)
      .optionallyWith(enaSupport.map(value => value.buildAwsValue()))(
        _.enaSupport
      )
      .optionallyWith(enclaveOptions.map(value => value.buildAwsValue()))(
        _.enclaveOptions
      )
      .optionallyWith(ebsOptimized.map(value => value.buildAwsValue()))(
        _.ebsOptimized
      )
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(
        instanceInitiatedShutdownBehavior.map(value => value.buildAwsValue())
      )(_.instanceInitiatedShutdownBehavior)
      .optionallyWith(instanceType.map(value => value.buildAwsValue()))(
        _.instanceType
      )
      .optionallyWith(kernelId.map(value => value.buildAwsValue()))(_.kernelId)
      .optionallyWith(
        productCodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productCodes)
      .optionallyWith(ramdiskId.map(value => value.buildAwsValue()))(
        _.ramdiskId
      )
      .optionallyWith(rootDeviceName.map(value => value.buildAwsValue()))(
        _.rootDeviceName
      )
      .optionallyWith(sourceDestCheck.map(value => value.buildAwsValue()))(
        _.sourceDestCheck
      )
      .optionallyWith(sriovNetSupport.map(value => value.buildAwsValue()))(
        _.sriovNetSupport
      )
      .optionallyWith(userData.map(value => value.buildAwsValue()))(_.userData)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeInstanceAttributeResponse.ReadOnly =
    zio.aws.ec2.model.DescribeInstanceAttributeResponse.wrap(buildAwsValue())
}
object DescribeInstanceAttributeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeInstanceAttributeResponse =
      zio.aws.ec2.model.DescribeInstanceAttributeResponse(
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        disableApiTermination.map(value => value.asEditable),
        enaSupport.map(value => value.asEditable),
        enclaveOptions.map(value => value.asEditable),
        ebsOptimized.map(value => value.asEditable),
        instanceId.map(value => value),
        instanceInitiatedShutdownBehavior.map(value => value.asEditable),
        instanceType.map(value => value.asEditable),
        kernelId.map(value => value.asEditable),
        productCodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ramdiskId.map(value => value.asEditable),
        rootDeviceName.map(value => value.asEditable),
        sourceDestCheck.map(value => value.asEditable),
        sriovNetSupport.map(value => value.asEditable),
        userData.map(value => value.asEditable)
      )
    def groups: Option[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]]
    def blockDeviceMappings
        : Option[List[zio.aws.ec2.model.InstanceBlockDeviceMapping.ReadOnly]]
    def disableApiTermination
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def enaSupport: Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def enclaveOptions: Option[zio.aws.ec2.model.EnclaveOptions.ReadOnly]
    def ebsOptimized: Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def instanceId: Option[String]
    def instanceInitiatedShutdownBehavior
        : Option[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def instanceType: Option[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def kernelId: Option[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def productCodes: Option[List[zio.aws.ec2.model.ProductCode.ReadOnly]]
    def ramdiskId: Option[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def rootDeviceName: Option[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def sourceDestCheck
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def sriovNetSupport: Option[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def userData: Option[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def getGroups
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] =
      AwsError.unwrapOptionField("groups", groups)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceBlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getDisableApiTermination
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("disableApiTermination", disableApiTermination)
    def getEnaSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("enaSupport", enaSupport)
    def getEnclaveOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.EnclaveOptions.ReadOnly] =
      AwsError.unwrapOptionField("enclaveOptions", enclaveOptions)
    def getEbsOptimized
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getInstanceInitiatedShutdownBehavior
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField(
        "instanceInitiatedShutdownBehavior",
        instanceInitiatedShutdownBehavior
      )
    def getInstanceType
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKernelId
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getProductCodes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ProductCode.ReadOnly]] =
      AwsError.unwrapOptionField("productCodes", productCodes)
    def getRamdiskId
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("ramdiskId", ramdiskId)
    def getRootDeviceName
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("rootDeviceName", rootDeviceName)
    def getSourceDestCheck
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("sourceDestCheck", sourceDestCheck)
    def getSriovNetSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("sriovNetSupport", sriovNetSupport)
    def getUserData
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("userData", userData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeResponse
  ) extends zio.aws.ec2.model.DescribeInstanceAttributeResponse.ReadOnly {
    override val groups
        : Option[List[zio.aws.ec2.model.GroupIdentifier.ReadOnly]] = scala
      .Option(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.GroupIdentifier.wrap(item)
        }.toList
      )
    override val blockDeviceMappings
        : Option[List[zio.aws.ec2.model.InstanceBlockDeviceMapping.ReadOnly]] =
      scala
        .Option(impl.blockDeviceMappings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstanceBlockDeviceMapping.wrap(item)
          }.toList
        )
    override val disableApiTermination
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] = scala
      .Option(impl.disableApiTermination())
      .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val enaSupport
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] = scala
      .Option(impl.enaSupport())
      .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val enclaveOptions
        : Option[zio.aws.ec2.model.EnclaveOptions.ReadOnly] = scala
      .Option(impl.enclaveOptions())
      .map(value => zio.aws.ec2.model.EnclaveOptions.wrap(value))
    override val ebsOptimized
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] = scala
      .Option(impl.ebsOptimized())
      .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val instanceId: Option[String] =
      scala.Option(impl.instanceId()).map(value => value: String)
    override val instanceInitiatedShutdownBehavior
        : Option[zio.aws.ec2.model.AttributeValue.ReadOnly] = scala
      .Option(impl.instanceInitiatedShutdownBehavior())
      .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val instanceType
        : Option[zio.aws.ec2.model.AttributeValue.ReadOnly] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val kernelId: Option[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      scala
        .Option(impl.kernelId())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val productCodes
        : Option[List[zio.aws.ec2.model.ProductCode.ReadOnly]] = scala
      .Option(impl.productCodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ProductCode.wrap(item)
        }.toList
      )
    override val ramdiskId: Option[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      scala
        .Option(impl.ramdiskId())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val rootDeviceName
        : Option[zio.aws.ec2.model.AttributeValue.ReadOnly] = scala
      .Option(impl.rootDeviceName())
      .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val sourceDestCheck
        : Option[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] = scala
      .Option(impl.sourceDestCheck())
      .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val sriovNetSupport
        : Option[zio.aws.ec2.model.AttributeValue.ReadOnly] = scala
      .Option(impl.sriovNetSupport())
      .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val userData: Option[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      scala
        .Option(impl.userData())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeResponse
  ): zio.aws.ec2.model.DescribeInstanceAttributeResponse.ReadOnly = new Wrapper(
    impl
  )
}
