package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ImageId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeImagesRequest(
    executableUsers: Option[Iterable[String]] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    imageIds: Option[Iterable[ImageId]] = None,
    owners: Option[Iterable[String]] = None,
    includeDeprecated: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeImagesRequest = {
    import DescribeImagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeImagesRequest
      .builder()
      .optionallyWith(
        executableUsers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.executableUsers)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        imageIds.map(value =>
          value.map { item =>
            ImageId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.imageIds)
      .optionallyWith(
        owners.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.owners)
      .optionallyWith(includeDeprecated.map(value => value: java.lang.Boolean))(
        _.includeDeprecated
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeImagesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeImagesRequest.wrap(buildAwsValue())
}
object DescribeImagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeImagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeImagesRequest =
      zio.aws.ec2.model.DescribeImagesRequest(
        executableUsers.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        imageIds.map(value => value),
        owners.map(value => value),
        includeDeprecated.map(value => value)
      )
    def executableUsers: Option[List[String]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def imageIds: Option[List[ImageId]]
    def owners: Option[List[String]]
    def includeDeprecated: Option[Boolean]
    def getExecutableUsers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("executableUsers", executableUsers)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getImageIds: ZIO[Any, AwsError, List[ImageId]] =
      AwsError.unwrapOptionField("imageIds", imageIds)
    def getOwners: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("owners", owners)
    def getIncludeDeprecated: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeDeprecated", includeDeprecated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImagesRequest
  ) extends zio.aws.ec2.model.DescribeImagesRequest.ReadOnly {
    override val executableUsers: Option[List[String]] = scala
      .Option(impl.executableUsers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val imageIds: Option[List[ImageId]] = scala
      .Option(impl.imageIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.ImageId(item)
        }.toList
      )
    override val owners: Option[List[String]] = scala
      .Option(impl.owners())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val includeDeprecated: Option[Boolean] =
      scala.Option(impl.includeDeprecated()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImagesRequest
  ): zio.aws.ec2.model.DescribeImagesRequest.ReadOnly = new Wrapper(impl)
}
