package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteTrafficMirrorTargetResponse(
    trafficMirrorTargetId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetResponse = {
    import DeleteTrafficMirrorTargetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetResponse
      .builder()
      .optionallyWith(
        trafficMirrorTargetId.map(value => value: java.lang.String)
      )(_.trafficMirrorTargetId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteTrafficMirrorTargetResponse.ReadOnly =
    zio.aws.ec2.model.DeleteTrafficMirrorTargetResponse.wrap(buildAwsValue())
}
object DeleteTrafficMirrorTargetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTrafficMirrorTargetResponse =
      zio.aws.ec2.model.DeleteTrafficMirrorTargetResponse(
        trafficMirrorTargetId.map(value => value)
      )
    def trafficMirrorTargetId: Option[String]
    def getTrafficMirrorTargetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("trafficMirrorTargetId", trafficMirrorTargetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetResponse
  ) extends zio.aws.ec2.model.DeleteTrafficMirrorTargetResponse.ReadOnly {
    override val trafficMirrorTargetId: Option[String] =
      scala.Option(impl.trafficMirrorTargetId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorTargetResponse
  ): zio.aws.ec2.model.DeleteTrafficMirrorTargetResponse.ReadOnly = new Wrapper(
    impl
  )
}
