package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  TransitGatewayId,
  VpnGatewayId,
  CustomerGatewayId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateVpnConnectionRequest(
    customerGatewayId: CustomerGatewayId,
    `type`: String,
    vpnGatewayId: Option[VpnGatewayId] = None,
    transitGatewayId: Option[TransitGatewayId] = None,
    options: Option[zio.aws.ec2.model.VpnConnectionOptionsSpecification] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRequest = {
    import CreateVpnConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRequest
      .builder()
      .customerGatewayId(
        CustomerGatewayId.unwrap(customerGatewayId): java.lang.String
      )
      .`type`(`type`: java.lang.String)
      .optionallyWith(
        vpnGatewayId.map(value => VpnGatewayId.unwrap(value): java.lang.String)
      )(_.vpnGatewayId)
      .optionallyWith(
        transitGatewayId.map(value =>
          TransitGatewayId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayId)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateVpnConnectionRequest.ReadOnly =
    zio.aws.ec2.model.CreateVpnConnectionRequest.wrap(buildAwsValue())
}
object CreateVpnConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVpnConnectionRequest =
      zio.aws.ec2.model.CreateVpnConnectionRequest(
        customerGatewayId,
        `type`,
        vpnGatewayId.map(value => value),
        transitGatewayId.map(value => value),
        options.map(value => value.asEditable),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def customerGatewayId: CustomerGatewayId
    def `type`: String
    def vpnGatewayId: Option[VpnGatewayId]
    def transitGatewayId: Option[TransitGatewayId]
    def options
        : Option[zio.aws.ec2.model.VpnConnectionOptionsSpecification.ReadOnly]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getCustomerGatewayId: ZIO[Any, Nothing, CustomerGatewayId] =
      ZIO.succeed(customerGatewayId)
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
    def getVpnGatewayId: ZIO[Any, AwsError, VpnGatewayId] =
      AwsError.unwrapOptionField("vpnGatewayId", vpnGatewayId)
    def getTransitGatewayId: ZIO[Any, AwsError, TransitGatewayId] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VpnConnectionOptionsSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRequest
  ) extends zio.aws.ec2.model.CreateVpnConnectionRequest.ReadOnly {
    override val customerGatewayId: CustomerGatewayId =
      zio.aws.ec2.model.primitives.CustomerGatewayId(impl.customerGatewayId())
    override val `type`: String = impl.`type`(): String
    override val vpnGatewayId: Option[VpnGatewayId] = scala
      .Option(impl.vpnGatewayId())
      .map(value => zio.aws.ec2.model.primitives.VpnGatewayId(value))
    override val transitGatewayId: Option[TransitGatewayId] = scala
      .Option(impl.transitGatewayId())
      .map(value => zio.aws.ec2.model.primitives.TransitGatewayId(value))
    override val options
        : Option[zio.aws.ec2.model.VpnConnectionOptionsSpecification.ReadOnly] =
      scala
        .Option(impl.options())
        .map(value =>
          zio.aws.ec2.model.VpnConnectionOptionsSpecification.wrap(value)
        )
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRequest
  ): zio.aws.ec2.model.CreateVpnConnectionRequest.ReadOnly = new Wrapper(impl)
}
