package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateVpcEndpointServiceConfigurationResponse(
    serviceConfiguration: Option[zio.aws.ec2.model.ServiceConfiguration] = None,
    clientToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationResponse = {
    import CreateVpcEndpointServiceConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationResponse
      .builder()
      .optionallyWith(serviceConfiguration.map(value => value.buildAwsValue()))(
        _.serviceConfiguration
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationResponse.ReadOnly =
    zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationResponse
      .wrap(buildAwsValue())
}
object CreateVpcEndpointServiceConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationResponse =
      zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationResponse(
        serviceConfiguration.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def serviceConfiguration
        : Option[zio.aws.ec2.model.ServiceConfiguration.ReadOnly]
    def clientToken: Option[String]
    def getServiceConfiguration
        : ZIO[Any, AwsError, zio.aws.ec2.model.ServiceConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("serviceConfiguration", serviceConfiguration)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationResponse
  ) extends zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationResponse.ReadOnly {
    override val serviceConfiguration
        : Option[zio.aws.ec2.model.ServiceConfiguration.ReadOnly] = scala
      .Option(impl.serviceConfiguration())
      .map(value => zio.aws.ec2.model.ServiceConfiguration.wrap(value))
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationResponse
  ): zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
