package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AttachNetworkInterfaceResponse(
    attachmentId: Option[String] = None,
    networkCardIndex: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceResponse = {
    import AttachNetworkInterfaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceResponse
      .builder()
      .optionallyWith(attachmentId.map(value => value: java.lang.String))(
        _.attachmentId
      )
      .optionallyWith(
        networkCardIndex.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.networkCardIndex)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AttachNetworkInterfaceResponse.ReadOnly =
    zio.aws.ec2.model.AttachNetworkInterfaceResponse.wrap(buildAwsValue())
}
object AttachNetworkInterfaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AttachNetworkInterfaceResponse =
      zio.aws.ec2.model.AttachNetworkInterfaceResponse(
        attachmentId.map(value => value),
        networkCardIndex.map(value => value)
      )
    def attachmentId: Option[String]
    def networkCardIndex: Option[Integer]
    def getAttachmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attachmentId", attachmentId)
    def getNetworkCardIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("networkCardIndex", networkCardIndex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceResponse
  ) extends zio.aws.ec2.model.AttachNetworkInterfaceResponse.ReadOnly {
    override val attachmentId: Option[String] =
      scala.Option(impl.attachmentId()).map(value => value: String)
    override val networkCardIndex: Option[Integer] = scala
      .Option(impl.networkCardIndex())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceResponse
  ): zio.aws.ec2.model.AttachNetworkInterfaceResponse.ReadOnly = new Wrapper(
    impl
  )
}
