package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssociateAddressResponse(
    associationId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateAddressResponse = {
    import AssociateAddressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateAddressResponse
      .builder()
      .optionallyWith(associationId.map(value => value: java.lang.String))(
        _.associationId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AssociateAddressResponse.ReadOnly =
    zio.aws.ec2.model.AssociateAddressResponse.wrap(buildAwsValue())
}
object AssociateAddressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateAddressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociateAddressResponse =
      zio.aws.ec2.model
        .AssociateAddressResponse(associationId.map(value => value))
    def associationId: Option[String]
    def getAssociationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associationId", associationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateAddressResponse
  ) extends zio.aws.ec2.model.AssociateAddressResponse.ReadOnly {
    override val associationId: Option[String] =
      scala.Option(impl.associationId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateAddressResponse
  ): zio.aws.ec2.model.AssociateAddressResponse.ReadOnly = new Wrapper(impl)
}
