package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait VolumeStatusName {
  def unwrap: software.amazon.awssdk.services.ec2.model.VolumeStatusName
}
object VolumeStatusName {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.VolumeStatusName
  ): zio.aws.ec2.model.VolumeStatusName = value match {
    case software.amazon.awssdk.services.ec2.model.VolumeStatusName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.VolumeStatusName.IO_ENABLED =>
      val r = `io-enabled`
      r
    case software.amazon.awssdk.services.ec2.model.VolumeStatusName.IO_PERFORMANCE =>
      val r = `io-performance`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.VolumeStatusName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VolumeStatusName =
      software.amazon.awssdk.services.ec2.model.VolumeStatusName.UNKNOWN_TO_SDK_VERSION
  }
  case object `io-enabled` extends zio.aws.ec2.model.VolumeStatusName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VolumeStatusName =
      software.amazon.awssdk.services.ec2.model.VolumeStatusName.IO_ENABLED
  }
  case object `io-performance` extends zio.aws.ec2.model.VolumeStatusName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VolumeStatusName =
      software.amazon.awssdk.services.ec2.model.VolumeStatusName.IO_PERFORMANCE
  }
}
