package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait VolumeAttachmentState {
  def unwrap: software.amazon.awssdk.services.ec2.model.VolumeAttachmentState
}
object VolumeAttachmentState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.VolumeAttachmentState
  ): zio.aws.ec2.model.VolumeAttachmentState = value match {
    case software.amazon.awssdk.services.ec2.model.VolumeAttachmentState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.VolumeAttachmentState.ATTACHING =>
      val r = attaching
      r
    case software.amazon.awssdk.services.ec2.model.VolumeAttachmentState.ATTACHED =>
      val r = attached
      r
    case software.amazon.awssdk.services.ec2.model.VolumeAttachmentState.DETACHING =>
      val r = detaching
      r
    case software.amazon.awssdk.services.ec2.model.VolumeAttachmentState.DETACHED =>
      val r = detached
      r
    case software.amazon.awssdk.services.ec2.model.VolumeAttachmentState.BUSY =>
      val r = busy
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.VolumeAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VolumeAttachmentState =
      software.amazon.awssdk.services.ec2.model.VolumeAttachmentState.UNKNOWN_TO_SDK_VERSION
  }
  case object attaching extends zio.aws.ec2.model.VolumeAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VolumeAttachmentState =
      software.amazon.awssdk.services.ec2.model.VolumeAttachmentState.ATTACHING
  }
  case object attached extends zio.aws.ec2.model.VolumeAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VolumeAttachmentState =
      software.amazon.awssdk.services.ec2.model.VolumeAttachmentState.ATTACHED
  }
  case object detaching extends zio.aws.ec2.model.VolumeAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VolumeAttachmentState =
      software.amazon.awssdk.services.ec2.model.VolumeAttachmentState.DETACHING
  }
  case object detached extends zio.aws.ec2.model.VolumeAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VolumeAttachmentState =
      software.amazon.awssdk.services.ec2.model.VolumeAttachmentState.DETACHED
  }
  case object busy extends zio.aws.ec2.model.VolumeAttachmentState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VolumeAttachmentState =
      software.amazon.awssdk.services.ec2.model.VolumeAttachmentState.BUSY
  }
}
