package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TrafficMirrorFilter(
    trafficMirrorFilterId: Option[String] = None,
    ingressFilterRules: Option[
      Iterable[zio.aws.ec2.model.TrafficMirrorFilterRule]
    ] = None,
    egressFilterRules: Option[
      Iterable[zio.aws.ec2.model.TrafficMirrorFilterRule]
    ] = None,
    networkServices: Option[
      Iterable[zio.aws.ec2.model.TrafficMirrorNetworkService]
    ] = None,
    description: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TrafficMirrorFilter = {
    import TrafficMirrorFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TrafficMirrorFilter
      .builder()
      .optionallyWith(
        trafficMirrorFilterId.map(value => value: java.lang.String)
      )(_.trafficMirrorFilterId)
      .optionallyWith(
        ingressFilterRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ingressFilterRules)
      .optionallyWith(
        egressFilterRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.egressFilterRules)
      .optionallyWith(
        networkServices.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.networkServicesWithStrings)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TrafficMirrorFilter.ReadOnly =
    zio.aws.ec2.model.TrafficMirrorFilter.wrap(buildAwsValue())
}
object TrafficMirrorFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TrafficMirrorFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TrafficMirrorFilter =
      zio.aws.ec2.model.TrafficMirrorFilter(
        trafficMirrorFilterId.map(value => value),
        ingressFilterRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        egressFilterRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkServices.map(value => value),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def trafficMirrorFilterId: Option[String]
    def ingressFilterRules
        : Option[List[zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly]]
    def egressFilterRules
        : Option[List[zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly]]
    def networkServices
        : Option[List[zio.aws.ec2.model.TrafficMirrorNetworkService]]
    def description: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTrafficMirrorFilterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("trafficMirrorFilterId", trafficMirrorFilterId)
    def getIngressFilterRules: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly
    ]] = AwsError.unwrapOptionField("ingressFilterRules", ingressFilterRules)
    def getEgressFilterRules: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly
    ]] = AwsError.unwrapOptionField("egressFilterRules", egressFilterRules)
    def getNetworkServices: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TrafficMirrorNetworkService
    ]] = AwsError.unwrapOptionField("networkServices", networkServices)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TrafficMirrorFilter
  ) extends zio.aws.ec2.model.TrafficMirrorFilter.ReadOnly {
    override val trafficMirrorFilterId: Option[String] =
      scala.Option(impl.trafficMirrorFilterId()).map(value => value: String)
    override val ingressFilterRules
        : Option[List[zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly]] =
      scala
        .Option(impl.ingressFilterRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TrafficMirrorFilterRule.wrap(item)
          }.toList
        )
    override val egressFilterRules
        : Option[List[zio.aws.ec2.model.TrafficMirrorFilterRule.ReadOnly]] =
      scala
        .Option(impl.egressFilterRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TrafficMirrorFilterRule.wrap(item)
          }.toList
        )
    override val networkServices
        : Option[List[zio.aws.ec2.model.TrafficMirrorNetworkService]] = scala
      .Option(impl.networkServices())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TrafficMirrorNetworkService.wrap(item)
        }.toList
      )
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TrafficMirrorFilter
  ): zio.aws.ec2.model.TrafficMirrorFilter.ReadOnly = new Wrapper(impl)
}
