package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StaleSecurityGroup(
    description: Option[String] = None,
    groupId: Option[String] = None,
    groupName: Option[String] = None,
    staleIpPermissions: Option[Iterable[zio.aws.ec2.model.StaleIpPermission]] =
      None,
    staleIpPermissionsEgress: Option[
      Iterable[zio.aws.ec2.model.StaleIpPermission]
    ] = None,
    vpcId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.StaleSecurityGroup = {
    import StaleSecurityGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.StaleSecurityGroup
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(groupId.map(value => value: java.lang.String))(_.groupId)
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .optionallyWith(
        staleIpPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.staleIpPermissions)
      .optionallyWith(
        staleIpPermissionsEgress.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.staleIpPermissionsEgress)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.StaleSecurityGroup.ReadOnly =
    zio.aws.ec2.model.StaleSecurityGroup.wrap(buildAwsValue())
}
object StaleSecurityGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.StaleSecurityGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.StaleSecurityGroup =
      zio.aws.ec2.model.StaleSecurityGroup(
        description.map(value => value),
        groupId.map(value => value),
        groupName.map(value => value),
        staleIpPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        staleIpPermissionsEgress.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcId.map(value => value)
      )
    def description: Option[String]
    def groupId: Option[String]
    def groupName: Option[String]
    def staleIpPermissions
        : Option[List[zio.aws.ec2.model.StaleIpPermission.ReadOnly]]
    def staleIpPermissionsEgress
        : Option[List[zio.aws.ec2.model.StaleIpPermission.ReadOnly]]
    def vpcId: Option[String]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getStaleIpPermissions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.StaleIpPermission.ReadOnly
    ]] = AwsError.unwrapOptionField("staleIpPermissions", staleIpPermissions)
    def getStaleIpPermissionsEgress: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.StaleIpPermission.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "staleIpPermissionsEgress",
      staleIpPermissionsEgress
    )
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.StaleSecurityGroup
  ) extends zio.aws.ec2.model.StaleSecurityGroup.ReadOnly {
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val groupId: Option[String] =
      scala.Option(impl.groupId()).map(value => value: String)
    override val groupName: Option[String] =
      scala.Option(impl.groupName()).map(value => value: String)
    override val staleIpPermissions
        : Option[List[zio.aws.ec2.model.StaleIpPermission.ReadOnly]] = scala
      .Option(impl.staleIpPermissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.StaleIpPermission.wrap(item)
        }.toList
      )
    override val staleIpPermissionsEgress
        : Option[List[zio.aws.ec2.model.StaleIpPermission.ReadOnly]] = scala
      .Option(impl.staleIpPermissionsEgress())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.StaleIpPermission.wrap(item)
        }.toList
      )
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.StaleSecurityGroup
  ): zio.aws.ec2.model.StaleSecurityGroup.ReadOnly = new Wrapper(impl)
}
