package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  DateTime,
  ReservedInstancesOfferingId,
  Integer
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class PurchaseReservedInstancesOfferingRequest(
    instanceCount: Integer,
    reservedInstancesOfferingId: ReservedInstancesOfferingId,
    limitPrice: Option[zio.aws.ec2.model.ReservedInstanceLimitPrice] = None,
    purchaseTime: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingRequest = {
    import PurchaseReservedInstancesOfferingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingRequest
      .builder()
      .instanceCount(Integer.unwrap(instanceCount): java.lang.Integer)
      .reservedInstancesOfferingId(
        ReservedInstancesOfferingId.unwrap(
          reservedInstancesOfferingId
        ): java.lang.String
      )
      .optionallyWith(limitPrice.map(value => value.buildAwsValue()))(
        _.limitPrice
      )
      .optionallyWith(
        purchaseTime.map(value => DateTime.unwrap(value): Instant)
      )(_.purchaseTime)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.PurchaseReservedInstancesOfferingRequest.ReadOnly =
    zio.aws.ec2.model.PurchaseReservedInstancesOfferingRequest
      .wrap(buildAwsValue())
}
object PurchaseReservedInstancesOfferingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PurchaseReservedInstancesOfferingRequest =
      zio.aws.ec2.model.PurchaseReservedInstancesOfferingRequest(
        instanceCount,
        reservedInstancesOfferingId,
        limitPrice.map(value => value.asEditable),
        purchaseTime.map(value => value)
      )
    def instanceCount: Integer
    def reservedInstancesOfferingId: ReservedInstancesOfferingId
    def limitPrice
        : Option[zio.aws.ec2.model.ReservedInstanceLimitPrice.ReadOnly]
    def purchaseTime: Option[DateTime]
    def getInstanceCount: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(instanceCount)
    def getReservedInstancesOfferingId
        : ZIO[Any, Nothing, ReservedInstancesOfferingId] =
      ZIO.succeed(reservedInstancesOfferingId)
    def getLimitPrice: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ReservedInstanceLimitPrice.ReadOnly
    ] = AwsError.unwrapOptionField("limitPrice", limitPrice)
    def getPurchaseTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("purchaseTime", purchaseTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingRequest
  ) extends zio.aws.ec2.model.PurchaseReservedInstancesOfferingRequest.ReadOnly {
    override val instanceCount: Integer =
      zio.aws.ec2.model.primitives.Integer(impl.instanceCount())
    override val reservedInstancesOfferingId: ReservedInstancesOfferingId =
      zio.aws.ec2.model.primitives
        .ReservedInstancesOfferingId(impl.reservedInstancesOfferingId())
    override val limitPrice
        : Option[zio.aws.ec2.model.ReservedInstanceLimitPrice.ReadOnly] = scala
      .Option(impl.limitPrice())
      .map(value => zio.aws.ec2.model.ReservedInstanceLimitPrice.wrap(value))
    override val purchaseTime: Option[DateTime] = scala
      .Option(impl.purchaseTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PurchaseReservedInstancesOfferingRequest
  ): zio.aws.ec2.model.PurchaseReservedInstancesOfferingRequest.ReadOnly =
    new Wrapper(impl)
}
