package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait NetworkInterfaceType {
  def unwrap: software.amazon.awssdk.services.ec2.model.NetworkInterfaceType
}
object NetworkInterfaceType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.NetworkInterfaceType
  ): zio.aws.ec2.model.NetworkInterfaceType = value match {
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.INTERFACE =>
      val r = interface
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.NAT_GATEWAY =>
      val r = natGateway
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.EFA =>
      val r = efa
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.TRUNK =>
      val r = trunk
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.UNKNOWN_TO_SDK_VERSION
  }
  case object interface extends zio.aws.ec2.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.INTERFACE
  }
  case object natGateway extends zio.aws.ec2.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.NAT_GATEWAY
  }
  case object efa extends zio.aws.ec2.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.EFA
  }
  case object trunk extends zio.aws.ec2.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.TRUNK
  }
}
