package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{DateTime, Integer, CapacityReservationId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ModifyCapacityReservationRequest(
    capacityReservationId: CapacityReservationId,
    instanceCount: Option[Integer] = None,
    endDate: Option[DateTime] = None,
    endDateType: Option[zio.aws.ec2.model.EndDateType] = None,
    accept: Option[Boolean] = None,
    additionalInfo: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationRequest = {
    import ModifyCapacityReservationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationRequest
      .builder()
      .capacityReservationId(
        CapacityReservationId.unwrap(capacityReservationId): java.lang.String
      )
      .optionallyWith(
        instanceCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.instanceCount)
      .optionallyWith(endDate.map(value => DateTime.unwrap(value): Instant))(
        _.endDate
      )
      .optionallyWith(endDateType.map(value => value.unwrap))(_.endDateType)
      .optionallyWith(accept.map(value => value: java.lang.Boolean))(_.accept)
      .optionallyWith(additionalInfo.map(value => value: java.lang.String))(
        _.additionalInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyCapacityReservationRequest.ReadOnly =
    zio.aws.ec2.model.ModifyCapacityReservationRequest.wrap(buildAwsValue())
}
object ModifyCapacityReservationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyCapacityReservationRequest =
      zio.aws.ec2.model.ModifyCapacityReservationRequest(
        capacityReservationId,
        instanceCount.map(value => value),
        endDate.map(value => value),
        endDateType.map(value => value),
        accept.map(value => value),
        additionalInfo.map(value => value)
      )
    def capacityReservationId: CapacityReservationId
    def instanceCount: Option[Integer]
    def endDate: Option[DateTime]
    def endDateType: Option[zio.aws.ec2.model.EndDateType]
    def accept: Option[Boolean]
    def additionalInfo: Option[String]
    def getCapacityReservationId: ZIO[Any, Nothing, CapacityReservationId] =
      ZIO.succeed(capacityReservationId)
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getEndDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getEndDateType: ZIO[Any, AwsError, zio.aws.ec2.model.EndDateType] =
      AwsError.unwrapOptionField("endDateType", endDateType)
    def getAccept: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("accept", accept)
    def getAdditionalInfo: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("additionalInfo", additionalInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationRequest
  ) extends zio.aws.ec2.model.ModifyCapacityReservationRequest.ReadOnly {
    override val capacityReservationId: CapacityReservationId =
      zio.aws.ec2.model.primitives
        .CapacityReservationId(impl.capacityReservationId())
    override val instanceCount: Option[Integer] = scala
      .Option(impl.instanceCount())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val endDate: Option[DateTime] = scala
      .Option(impl.endDate())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val endDateType: Option[zio.aws.ec2.model.EndDateType] = scala
      .Option(impl.endDateType())
      .map(value => zio.aws.ec2.model.EndDateType.wrap(value))
    override val accept: Option[Boolean] =
      scala.Option(impl.accept()).map(value => value: Boolean)
    override val additionalInfo: Option[String] =
      scala.Option(impl.additionalInfo()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyCapacityReservationRequest
  ): zio.aws.ec2.model.ModifyCapacityReservationRequest.ReadOnly = new Wrapper(
    impl
  )
}
