package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LaunchTemplateEnclaveOptionsRequest(
    enabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateEnclaveOptionsRequest = {
    import LaunchTemplateEnclaveOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateEnclaveOptionsRequest
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.LaunchTemplateEnclaveOptionsRequest.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateEnclaveOptionsRequest.wrap(buildAwsValue())
}
object LaunchTemplateEnclaveOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateEnclaveOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchTemplateEnclaveOptionsRequest =
      zio.aws.ec2.model
        .LaunchTemplateEnclaveOptionsRequest(enabled.map(value => value))
    def enabled: Option[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateEnclaveOptionsRequest
  ) extends zio.aws.ec2.model.LaunchTemplateEnclaveOptionsRequest.ReadOnly {
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateEnclaveOptionsRequest
  ): zio.aws.ec2.model.LaunchTemplateEnclaveOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
