package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetSpotPlacementScoresResponse(
    spotPlacementScores: Option[
      Iterable[zio.aws.ec2.model.SpotPlacementScore]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresResponse = {
    import GetSpotPlacementScoresResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresResponse
      .builder()
      .optionallyWith(
        spotPlacementScores.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.spotPlacementScores)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetSpotPlacementScoresResponse.ReadOnly =
    zio.aws.ec2.model.GetSpotPlacementScoresResponse.wrap(buildAwsValue())
}
object GetSpotPlacementScoresResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetSpotPlacementScoresResponse =
      zio.aws.ec2.model.GetSpotPlacementScoresResponse(
        spotPlacementScores.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def spotPlacementScores
        : Option[List[zio.aws.ec2.model.SpotPlacementScore.ReadOnly]]
    def nextToken: Option[String]
    def getSpotPlacementScores: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.SpotPlacementScore.ReadOnly
    ]] = AwsError.unwrapOptionField("spotPlacementScores", spotPlacementScores)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresResponse
  ) extends zio.aws.ec2.model.GetSpotPlacementScoresResponse.ReadOnly {
    override val spotPlacementScores
        : Option[List[zio.aws.ec2.model.SpotPlacementScore.ReadOnly]] = scala
      .Option(impl.spotPlacementScores())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.SpotPlacementScore.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetSpotPlacementScoresResponse
  ): zio.aws.ec2.model.GetSpotPlacementScoresResponse.ReadOnly = new Wrapper(
    impl
  )
}
