package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetSerialConsoleAccessStatusResponse(
    serialConsoleAccessEnabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetSerialConsoleAccessStatusResponse = {
    import GetSerialConsoleAccessStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetSerialConsoleAccessStatusResponse
      .builder()
      .optionallyWith(
        serialConsoleAccessEnabled.map(value => value: java.lang.Boolean)
      )(_.serialConsoleAccessEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetSerialConsoleAccessStatusResponse.ReadOnly =
    zio.aws.ec2.model.GetSerialConsoleAccessStatusResponse.wrap(buildAwsValue())
}
object GetSerialConsoleAccessStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetSerialConsoleAccessStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetSerialConsoleAccessStatusResponse =
      zio.aws.ec2.model.GetSerialConsoleAccessStatusResponse(
        serialConsoleAccessEnabled.map(value => value)
      )
    def serialConsoleAccessEnabled: Option[Boolean]
    def getSerialConsoleAccessEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "serialConsoleAccessEnabled",
        serialConsoleAccessEnabled
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetSerialConsoleAccessStatusResponse
  ) extends zio.aws.ec2.model.GetSerialConsoleAccessStatusResponse.ReadOnly {
    override val serialConsoleAccessEnabled: Option[Boolean] = scala
      .Option(impl.serialConsoleAccessEnabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetSerialConsoleAccessStatusResponse
  ): zio.aws.ec2.model.GetSerialConsoleAccessStatusResponse.ReadOnly =
    new Wrapper(impl)
}
