package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetManagedPrefixListAssociationsResponse(
    prefixListAssociations: Option[
      Iterable[zio.aws.ec2.model.PrefixListAssociation]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsResponse = {
    import GetManagedPrefixListAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsResponse
      .builder()
      .optionallyWith(
        prefixListAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.prefixListAssociations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetManagedPrefixListAssociationsResponse.ReadOnly =
    zio.aws.ec2.model.GetManagedPrefixListAssociationsResponse
      .wrap(buildAwsValue())
}
object GetManagedPrefixListAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetManagedPrefixListAssociationsResponse =
      zio.aws.ec2.model.GetManagedPrefixListAssociationsResponse(
        prefixListAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def prefixListAssociations
        : Option[List[zio.aws.ec2.model.PrefixListAssociation.ReadOnly]]
    def nextToken: Option[String]
    def getPrefixListAssociations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.PrefixListAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "prefixListAssociations",
      prefixListAssociations
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsResponse
  ) extends zio.aws.ec2.model.GetManagedPrefixListAssociationsResponse.ReadOnly {
    override val prefixListAssociations
        : Option[List[zio.aws.ec2.model.PrefixListAssociation.ReadOnly]] = scala
      .Option(impl.prefixListAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.PrefixListAssociation.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetManagedPrefixListAssociationsResponse
  ): zio.aws.ec2.model.GetManagedPrefixListAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
