package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetAssociatedEnclaveCertificateIamRolesResponse(
    associatedRoles: Option[Iterable[zio.aws.ec2.model.AssociatedRole]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesResponse = {
    import GetAssociatedEnclaveCertificateIamRolesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesResponse
      .builder()
      .optionallyWith(
        associatedRoles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associatedRoles)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesResponse.ReadOnly =
    zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesResponse
      .wrap(buildAwsValue())
}
object GetAssociatedEnclaveCertificateIamRolesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesResponse =
      zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesResponse(
        associatedRoles.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def associatedRoles: Option[List[zio.aws.ec2.model.AssociatedRole.ReadOnly]]
    def getAssociatedRoles
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.AssociatedRole.ReadOnly]] =
      AwsError.unwrapOptionField("associatedRoles", associatedRoles)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesResponse
  ) extends zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesResponse.ReadOnly {
    override val associatedRoles
        : Option[List[zio.aws.ec2.model.AssociatedRole.ReadOnly]] = scala
      .Option(impl.associatedRoles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.AssociatedRole.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesResponse
  ): zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesResponse.ReadOnly =
    new Wrapper(impl)
}
