package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, ImageId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EnableFastLaunchRequest(
    imageId: ImageId,
    resourceType: Option[String] = None,
    snapshotConfiguration: Option[
      zio.aws.ec2.model.FastLaunchSnapshotConfigurationRequest
    ] = None,
    launchTemplate: Option[
      zio.aws.ec2.model.FastLaunchLaunchTemplateSpecificationRequest
    ] = None,
    maxParallelLaunches: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableFastLaunchRequest = {
    import EnableFastLaunchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableFastLaunchRequest
      .builder()
      .imageId(ImageId.unwrap(imageId): java.lang.String)
      .optionallyWith(resourceType.map(value => value: java.lang.String))(
        _.resourceType
      )
      .optionallyWith(
        snapshotConfiguration.map(value => value.buildAwsValue())
      )(_.snapshotConfiguration)
      .optionallyWith(launchTemplate.map(value => value.buildAwsValue()))(
        _.launchTemplate
      )
      .optionallyWith(
        maxParallelLaunches.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.maxParallelLaunches)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EnableFastLaunchRequest.ReadOnly =
    zio.aws.ec2.model.EnableFastLaunchRequest.wrap(buildAwsValue())
}
object EnableFastLaunchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableFastLaunchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnableFastLaunchRequest =
      zio.aws.ec2.model.EnableFastLaunchRequest(
        imageId,
        resourceType.map(value => value),
        snapshotConfiguration.map(value => value.asEditable),
        launchTemplate.map(value => value.asEditable),
        maxParallelLaunches.map(value => value)
      )
    def imageId: ImageId
    def resourceType: Option[String]
    def snapshotConfiguration: Option[
      zio.aws.ec2.model.FastLaunchSnapshotConfigurationRequest.ReadOnly
    ]
    def launchTemplate: Option[
      zio.aws.ec2.model.FastLaunchLaunchTemplateSpecificationRequest.ReadOnly
    ]
    def maxParallelLaunches: Option[Integer]
    def getImageId: ZIO[Any, Nothing, ImageId] = ZIO.succeed(imageId)
    def getResourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getSnapshotConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FastLaunchSnapshotConfigurationRequest.ReadOnly
    ] =
      AwsError.unwrapOptionField("snapshotConfiguration", snapshotConfiguration)
    def getLaunchTemplate: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FastLaunchLaunchTemplateSpecificationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("launchTemplate", launchTemplate)
    def getMaxParallelLaunches: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxParallelLaunches", maxParallelLaunches)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableFastLaunchRequest
  ) extends zio.aws.ec2.model.EnableFastLaunchRequest.ReadOnly {
    override val imageId: ImageId =
      zio.aws.ec2.model.primitives.ImageId(impl.imageId())
    override val resourceType: Option[String] =
      scala.Option(impl.resourceType()).map(value => value: String)
    override val snapshotConfiguration: Option[
      zio.aws.ec2.model.FastLaunchSnapshotConfigurationRequest.ReadOnly
    ] = scala
      .Option(impl.snapshotConfiguration())
      .map(value =>
        zio.aws.ec2.model.FastLaunchSnapshotConfigurationRequest.wrap(value)
      )
    override val launchTemplate: Option[
      zio.aws.ec2.model.FastLaunchLaunchTemplateSpecificationRequest.ReadOnly
    ] = scala
      .Option(impl.launchTemplate())
      .map(value =>
        zio.aws.ec2.model.FastLaunchLaunchTemplateSpecificationRequest
          .wrap(value)
      )
    override val maxParallelLaunches: Option[Integer] = scala
      .Option(impl.maxParallelLaunches())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableFastLaunchRequest
  ): zio.aws.ec2.model.EnableFastLaunchRequest.ReadOnly = new Wrapper(impl)
}
