package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{TransitGatewayMaxResults, TransitGatewayId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeTransitGatewaysRequest(
    transitGatewayIds: Option[Iterable[TransitGatewayId]] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[TransitGatewayMaxResults] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTransitGatewaysRequest = {
    import DescribeTransitGatewaysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewaysRequest
      .builder()
      .optionallyWith(
        transitGatewayIds.map(value =>
          value.map { item =>
            TransitGatewayId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.transitGatewayIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => TransitGatewayMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeTransitGatewaysRequest.ReadOnly =
    zio.aws.ec2.model.DescribeTransitGatewaysRequest.wrap(buildAwsValue())
}
object DescribeTransitGatewaysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewaysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeTransitGatewaysRequest =
      zio.aws.ec2.model.DescribeTransitGatewaysRequest(
        transitGatewayIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def transitGatewayIds: Option[List[TransitGatewayId]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[TransitGatewayMaxResults]
    def nextToken: Option[String]
    def getTransitGatewayIds: ZIO[Any, AwsError, List[TransitGatewayId]] =
      AwsError.unwrapOptionField("transitGatewayIds", transitGatewayIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, TransitGatewayMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewaysRequest
  ) extends zio.aws.ec2.model.DescribeTransitGatewaysRequest.ReadOnly {
    override val transitGatewayIds: Option[List[TransitGatewayId]] = scala
      .Option(impl.transitGatewayIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.TransitGatewayId(item)
        }.toList
      )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[TransitGatewayMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayMaxResults(value)
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewaysRequest
  ): zio.aws.ec2.model.DescribeTransitGatewaysRequest.ReadOnly = new Wrapper(
    impl
  )
}
