package zio.aws.ec2.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  MillisecondDateTime,
  NetworkInsightsPathId,
  NetworkInsightsAnalysisId,
  NetworkInsightsMaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeNetworkInsightsAnalysesRequest(
    networkInsightsAnalysisIds: Option[Iterable[NetworkInsightsAnalysisId]] =
      None,
    networkInsightsPathId: Option[NetworkInsightsPathId] = None,
    analysisStartTime: Option[MillisecondDateTime] = None,
    analysisEndTime: Option[MillisecondDateTime] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[NetworkInsightsMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesRequest = {
    import DescribeNetworkInsightsAnalysesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesRequest
      .builder()
      .optionallyWith(
        networkInsightsAnalysisIds.map(value =>
          value.map { item =>
            NetworkInsightsAnalysisId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.networkInsightsAnalysisIds)
      .optionallyWith(
        networkInsightsPathId.map(value =>
          NetworkInsightsPathId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsPathId)
      .optionallyWith(
        analysisStartTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.analysisStartTime)
      .optionallyWith(
        analysisEndTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.analysisEndTime)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          NetworkInsightsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeNetworkInsightsAnalysesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeNetworkInsightsAnalysesRequest
      .wrap(buildAwsValue())
}
object DescribeNetworkInsightsAnalysesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeNetworkInsightsAnalysesRequest =
      zio.aws.ec2.model.DescribeNetworkInsightsAnalysesRequest(
        networkInsightsAnalysisIds.map(value => value),
        networkInsightsPathId.map(value => value),
        analysisStartTime.map(value => value),
        analysisEndTime.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def networkInsightsAnalysisIds: Option[List[NetworkInsightsAnalysisId]]
    def networkInsightsPathId: Option[NetworkInsightsPathId]
    def analysisStartTime: Option[MillisecondDateTime]
    def analysisEndTime: Option[MillisecondDateTime]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[NetworkInsightsMaxResults]
    def nextToken: Option[NextToken]
    def getNetworkInsightsAnalysisIds
        : ZIO[Any, AwsError, List[NetworkInsightsAnalysisId]] =
      AwsError.unwrapOptionField(
        "networkInsightsAnalysisIds",
        networkInsightsAnalysisIds
      )
    def getNetworkInsightsPathId: ZIO[Any, AwsError, NetworkInsightsPathId] =
      AwsError.unwrapOptionField("networkInsightsPathId", networkInsightsPathId)
    def getAnalysisStartTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("analysisStartTime", analysisStartTime)
    def getAnalysisEndTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("analysisEndTime", analysisEndTime)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, NetworkInsightsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesRequest
  ) extends zio.aws.ec2.model.DescribeNetworkInsightsAnalysesRequest.ReadOnly {
    override val networkInsightsAnalysisIds
        : Option[List[NetworkInsightsAnalysisId]] = scala
      .Option(impl.networkInsightsAnalysisIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.NetworkInsightsAnalysisId(item)
        }.toList
      )
    override val networkInsightsPathId: Option[NetworkInsightsPathId] = scala
      .Option(impl.networkInsightsPathId())
      .map(value => zio.aws.ec2.model.primitives.NetworkInsightsPathId(value))
    override val analysisStartTime: Option[MillisecondDateTime] = scala
      .Option(impl.analysisStartTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val analysisEndTime: Option[MillisecondDateTime] = scala
      .Option(impl.analysisEndTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[NetworkInsightsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.NetworkInsightsMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInsightsAnalysesRequest
  ): zio.aws.ec2.model.DescribeNetworkInsightsAnalysesRequest.ReadOnly =
    new Wrapper(impl)
}
