package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeIdFormatRequest(resource: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeIdFormatRequest = {
    import DescribeIdFormatRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeIdFormatRequest
      .builder()
      .optionallyWith(resource.map(value => value: java.lang.String))(
        _.resource
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeIdFormatRequest.ReadOnly =
    zio.aws.ec2.model.DescribeIdFormatRequest.wrap(buildAwsValue())
}
object DescribeIdFormatRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeIdFormatRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeIdFormatRequest =
      zio.aws.ec2.model.DescribeIdFormatRequest(resource.map(value => value))
    def resource: Option[String]
    def getResource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resource", resource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIdFormatRequest
  ) extends zio.aws.ec2.model.DescribeIdFormatRequest.ReadOnly {
    override val resource: Option[String] =
      scala.Option(impl.resource()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIdFormatRequest
  ): zio.aws.ec2.model.DescribeIdFormatRequest.ReadOnly = new Wrapper(impl)
}
