package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.BundleId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeBundleTasksRequest(
    bundleIds: Option[Iterable[BundleId]] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest = {
    import DescribeBundleTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest
      .builder()
      .optionallyWith(
        bundleIds.map(value =>
          value.map { item =>
            BundleId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.bundleIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeBundleTasksRequest.ReadOnly =
    zio.aws.ec2.model.DescribeBundleTasksRequest.wrap(buildAwsValue())
}
object DescribeBundleTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeBundleTasksRequest =
      zio.aws.ec2.model.DescribeBundleTasksRequest(
        bundleIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def bundleIds: Option[List[BundleId]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def getBundleIds: ZIO[Any, AwsError, List[BundleId]] =
      AwsError.unwrapOptionField("bundleIds", bundleIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest
  ) extends zio.aws.ec2.model.DescribeBundleTasksRequest.ReadOnly {
    override val bundleIds: Option[List[BundleId]] = scala
      .Option(impl.bundleIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.BundleId(item)
        }.toList
      )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest
  ): zio.aws.ec2.model.DescribeBundleTasksRequest.ReadOnly = new Wrapper(impl)
}
