package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcEndpointId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVpcEndpointsRequest(
    vpcEndpointIds: Iterable[VpcEndpointId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointsRequest = {
    import DeleteVpcEndpointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointsRequest
      .builder()
      .vpcEndpointIds(vpcEndpointIds.map { item =>
        VpcEndpointId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteVpcEndpointsRequest.ReadOnly =
    zio.aws.ec2.model.DeleteVpcEndpointsRequest.wrap(buildAwsValue())
}
object DeleteVpcEndpointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteVpcEndpointsRequest =
      zio.aws.ec2.model.DeleteVpcEndpointsRequest(vpcEndpointIds)
    def vpcEndpointIds: List[VpcEndpointId]
    def getVpcEndpointIds: ZIO[Any, Nothing, List[VpcEndpointId]] =
      ZIO.succeed(vpcEndpointIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointsRequest
  ) extends zio.aws.ec2.model.DeleteVpcEndpointsRequest.ReadOnly {
    override val vpcEndpointIds: List[VpcEndpointId] = impl
      .vpcEndpointIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.VpcEndpointId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointsRequest
  ): zio.aws.ec2.model.DeleteVpcEndpointsRequest.ReadOnly = new Wrapper(impl)
}
