package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.FleetId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteFleetErrorItem(
    error: Option[zio.aws.ec2.model.DeleteFleetError] = None,
    fleetId: Option[FleetId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteFleetErrorItem = {
    import DeleteFleetErrorItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteFleetErrorItem
      .builder()
      .optionallyWith(error.map(value => value.buildAwsValue()))(_.error)
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteFleetErrorItem.ReadOnly =
    zio.aws.ec2.model.DeleteFleetErrorItem.wrap(buildAwsValue())
}
object DeleteFleetErrorItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteFleetErrorItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteFleetErrorItem =
      zio.aws.ec2.model.DeleteFleetErrorItem(
        error.map(value => value.asEditable),
        fleetId.map(value => value)
      )
    def error: Option[zio.aws.ec2.model.DeleteFleetError.ReadOnly]
    def fleetId: Option[FleetId]
    def getError
        : ZIO[Any, AwsError, zio.aws.ec2.model.DeleteFleetError.ReadOnly] =
      AwsError.unwrapOptionField("error", error)
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteFleetErrorItem
  ) extends zio.aws.ec2.model.DeleteFleetErrorItem.ReadOnly {
    override val error: Option[zio.aws.ec2.model.DeleteFleetError.ReadOnly] =
      scala
        .Option(impl.error())
        .map(value => zio.aws.ec2.model.DeleteFleetError.wrap(value))
    override val fleetId: Option[FleetId] = scala
      .Option(impl.fleetId())
      .map(value => zio.aws.ec2.model.primitives.FleetId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteFleetErrorItem
  ): zio.aws.ec2.model.DeleteFleetErrorItem.ReadOnly = new Wrapper(impl)
}
