package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateVpnConnectionResponse(
    vpnConnection: Option[zio.aws.ec2.model.VpnConnection] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateVpnConnectionResponse = {
    import CreateVpnConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateVpnConnectionResponse
      .builder()
      .optionallyWith(vpnConnection.map(value => value.buildAwsValue()))(
        _.vpnConnection
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateVpnConnectionResponse.ReadOnly =
    zio.aws.ec2.model.CreateVpnConnectionResponse.wrap(buildAwsValue())
}
object CreateVpnConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateVpnConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateVpnConnectionResponse =
      zio.aws.ec2.model.CreateVpnConnectionResponse(
        vpnConnection.map(value => value.asEditable)
      )
    def vpnConnection: Option[zio.aws.ec2.model.VpnConnection.ReadOnly]
    def getVpnConnection
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpnConnection.ReadOnly] =
      AwsError.unwrapOptionField("vpnConnection", vpnConnection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpnConnectionResponse
  ) extends zio.aws.ec2.model.CreateVpnConnectionResponse.ReadOnly {
    override val vpnConnection
        : Option[zio.aws.ec2.model.VpnConnection.ReadOnly] = scala
      .Option(impl.vpnConnection())
      .map(value => zio.aws.ec2.model.VpnConnection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateVpnConnectionResponse
  ): zio.aws.ec2.model.CreateVpnConnectionResponse.ReadOnly = new Wrapper(impl)
}
