package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateTransitGatewayMulticastDomainRequestOptions(
    igmpv2Support: Option[zio.aws.ec2.model.Igmpv2SupportValue] = None,
    staticSourcesSupport: Option[zio.aws.ec2.model.StaticSourcesSupportValue] =
      None,
    autoAcceptSharedAssociations: Option[
      zio.aws.ec2.model.AutoAcceptSharedAssociationsValue
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainRequestOptions = {
    import CreateTransitGatewayMulticastDomainRequestOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainRequestOptions
      .builder()
      .optionallyWith(igmpv2Support.map(value => value.unwrap))(_.igmpv2Support)
      .optionallyWith(staticSourcesSupport.map(value => value.unwrap))(
        _.staticSourcesSupport
      )
      .optionallyWith(autoAcceptSharedAssociations.map(value => value.unwrap))(
        _.autoAcceptSharedAssociations
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequestOptions.ReadOnly =
    zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequestOptions
      .wrap(buildAwsValue())
}
object CreateTransitGatewayMulticastDomainRequestOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainRequestOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequestOptions =
      zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequestOptions(
        igmpv2Support.map(value => value),
        staticSourcesSupport.map(value => value),
        autoAcceptSharedAssociations.map(value => value)
      )
    def igmpv2Support: Option[zio.aws.ec2.model.Igmpv2SupportValue]
    def staticSourcesSupport
        : Option[zio.aws.ec2.model.StaticSourcesSupportValue]
    def autoAcceptSharedAssociations
        : Option[zio.aws.ec2.model.AutoAcceptSharedAssociationsValue]
    def getIgmpv2Support
        : ZIO[Any, AwsError, zio.aws.ec2.model.Igmpv2SupportValue] =
      AwsError.unwrapOptionField("igmpv2Support", igmpv2Support)
    def getStaticSourcesSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.StaticSourcesSupportValue] =
      AwsError.unwrapOptionField("staticSourcesSupport", staticSourcesSupport)
    def getAutoAcceptSharedAssociations: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.AutoAcceptSharedAssociationsValue
    ] = AwsError.unwrapOptionField(
      "autoAcceptSharedAssociations",
      autoAcceptSharedAssociations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainRequestOptions
  ) extends zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequestOptions.ReadOnly {
    override val igmpv2Support: Option[zio.aws.ec2.model.Igmpv2SupportValue] =
      scala
        .Option(impl.igmpv2Support())
        .map(value => zio.aws.ec2.model.Igmpv2SupportValue.wrap(value))
    override val staticSourcesSupport
        : Option[zio.aws.ec2.model.StaticSourcesSupportValue] = scala
      .Option(impl.staticSourcesSupport())
      .map(value => zio.aws.ec2.model.StaticSourcesSupportValue.wrap(value))
    override val autoAcceptSharedAssociations
        : Option[zio.aws.ec2.model.AutoAcceptSharedAssociationsValue] = scala
      .Option(impl.autoAcceptSharedAssociations())
      .map(value =>
        zio.aws.ec2.model.AutoAcceptSharedAssociationsValue.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayMulticastDomainRequestOptions
  ): zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequestOptions.ReadOnly =
    new Wrapper(impl)
}
