package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateNatGatewayResponse(
    clientToken: Option[String] = None,
    natGateway: Option[zio.aws.ec2.model.NatGateway] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateNatGatewayResponse = {
    import CreateNatGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateNatGatewayResponse
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(natGateway.map(value => value.buildAwsValue()))(
        _.natGateway
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateNatGatewayResponse.ReadOnly =
    zio.aws.ec2.model.CreateNatGatewayResponse.wrap(buildAwsValue())
}
object CreateNatGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateNatGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateNatGatewayResponse =
      zio.aws.ec2.model.CreateNatGatewayResponse(
        clientToken.map(value => value),
        natGateway.map(value => value.asEditable)
      )
    def clientToken: Option[String]
    def natGateway: Option[zio.aws.ec2.model.NatGateway.ReadOnly]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getNatGateway
        : ZIO[Any, AwsError, zio.aws.ec2.model.NatGateway.ReadOnly] =
      AwsError.unwrapOptionField("natGateway", natGateway)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateNatGatewayResponse
  ) extends zio.aws.ec2.model.CreateNatGatewayResponse.ReadOnly {
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val natGateway: Option[zio.aws.ec2.model.NatGateway.ReadOnly] =
      scala
        .Option(impl.natGateway())
        .map(value => zio.aws.ec2.model.NatGateway.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateNatGatewayResponse
  ): zio.aws.ec2.model.CreateNatGatewayResponse.ReadOnly = new Wrapper(impl)
}
