package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{IpamNetmaskLength, IpamPoolId, IpamScopeId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateIpamPoolRequest(
    ipamScopeId: IpamScopeId,
    locale: Option[String] = None,
    sourceIpamPoolId: Option[IpamPoolId] = None,
    description: Option[String] = None,
    addressFamily: Option[zio.aws.ec2.model.AddressFamily] = None,
    autoImport: Option[Boolean] = None,
    publiclyAdvertisable: Option[Boolean] = None,
    allocationMinNetmaskLength: Option[IpamNetmaskLength] = None,
    allocationMaxNetmaskLength: Option[IpamNetmaskLength] = None,
    allocationDefaultNetmaskLength: Option[IpamNetmaskLength] = None,
    allocationResourceTags: Option[
      Iterable[zio.aws.ec2.model.RequestIpamResourceTag]
    ] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None,
    clientToken: Option[String] = None,
    awsService: Option[zio.aws.ec2.model.IpamPoolAwsService] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateIpamPoolRequest = {
    import CreateIpamPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateIpamPoolRequest
      .builder()
      .ipamScopeId(IpamScopeId.unwrap(ipamScopeId): java.lang.String)
      .optionallyWith(locale.map(value => value: java.lang.String))(_.locale)
      .optionallyWith(
        sourceIpamPoolId.map(value =>
          IpamPoolId.unwrap(value): java.lang.String
        )
      )(_.sourceIpamPoolId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily)
      .optionallyWith(autoImport.map(value => value: java.lang.Boolean))(
        _.autoImport
      )
      .optionallyWith(
        publiclyAdvertisable.map(value => value: java.lang.Boolean)
      )(_.publiclyAdvertisable)
      .optionallyWith(
        allocationMinNetmaskLength.map(value =>
          IpamNetmaskLength.unwrap(value): Integer
        )
      )(_.allocationMinNetmaskLength)
      .optionallyWith(
        allocationMaxNetmaskLength.map(value =>
          IpamNetmaskLength.unwrap(value): Integer
        )
      )(_.allocationMaxNetmaskLength)
      .optionallyWith(
        allocationDefaultNetmaskLength.map(value =>
          IpamNetmaskLength.unwrap(value): Integer
        )
      )(_.allocationDefaultNetmaskLength)
      .optionallyWith(
        allocationResourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.allocationResourceTags)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(awsService.map(value => value.unwrap))(_.awsService)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateIpamPoolRequest.ReadOnly =
    zio.aws.ec2.model.CreateIpamPoolRequest.wrap(buildAwsValue())
}
object CreateIpamPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateIpamPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateIpamPoolRequest =
      zio.aws.ec2.model.CreateIpamPoolRequest(
        ipamScopeId,
        locale.map(value => value),
        sourceIpamPoolId.map(value => value),
        description.map(value => value),
        addressFamily.map(value => value),
        autoImport.map(value => value),
        publiclyAdvertisable.map(value => value),
        allocationMinNetmaskLength.map(value => value),
        allocationMaxNetmaskLength.map(value => value),
        allocationDefaultNetmaskLength.map(value => value),
        allocationResourceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value),
        awsService.map(value => value)
      )
    def ipamScopeId: IpamScopeId
    def locale: Option[String]
    def sourceIpamPoolId: Option[IpamPoolId]
    def description: Option[String]
    def addressFamily: Option[zio.aws.ec2.model.AddressFamily]
    def autoImport: Option[Boolean]
    def publiclyAdvertisable: Option[Boolean]
    def allocationMinNetmaskLength: Option[IpamNetmaskLength]
    def allocationMaxNetmaskLength: Option[IpamNetmaskLength]
    def allocationDefaultNetmaskLength: Option[IpamNetmaskLength]
    def allocationResourceTags
        : Option[List[zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly]]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def clientToken: Option[String]
    def awsService: Option[zio.aws.ec2.model.IpamPoolAwsService]
    def getIpamScopeId: ZIO[Any, Nothing, IpamScopeId] =
      ZIO.succeed(ipamScopeId)
    def getLocale: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("locale", locale)
    def getSourceIpamPoolId: ZIO[Any, AwsError, IpamPoolId] =
      AwsError.unwrapOptionField("sourceIpamPoolId", sourceIpamPoolId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getAddressFamily: ZIO[Any, AwsError, zio.aws.ec2.model.AddressFamily] =
      AwsError.unwrapOptionField("addressFamily", addressFamily)
    def getAutoImport: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoImport", autoImport)
    def getPubliclyAdvertisable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAdvertisable", publiclyAdvertisable)
    def getAllocationMinNetmaskLength: ZIO[Any, AwsError, IpamNetmaskLength] =
      AwsError.unwrapOptionField(
        "allocationMinNetmaskLength",
        allocationMinNetmaskLength
      )
    def getAllocationMaxNetmaskLength: ZIO[Any, AwsError, IpamNetmaskLength] =
      AwsError.unwrapOptionField(
        "allocationMaxNetmaskLength",
        allocationMaxNetmaskLength
      )
    def getAllocationDefaultNetmaskLength
        : ZIO[Any, AwsError, IpamNetmaskLength] = AwsError.unwrapOptionField(
      "allocationDefaultNetmaskLength",
      allocationDefaultNetmaskLength
    )
    def getAllocationResourceTags: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "allocationResourceTags",
      allocationResourceTags
    )
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getAwsService
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamPoolAwsService] =
      AwsError.unwrapOptionField("awsService", awsService)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateIpamPoolRequest
  ) extends zio.aws.ec2.model.CreateIpamPoolRequest.ReadOnly {
    override val ipamScopeId: IpamScopeId =
      zio.aws.ec2.model.primitives.IpamScopeId(impl.ipamScopeId())
    override val locale: Option[String] =
      scala.Option(impl.locale()).map(value => value: String)
    override val sourceIpamPoolId: Option[IpamPoolId] = scala
      .Option(impl.sourceIpamPoolId())
      .map(value => zio.aws.ec2.model.primitives.IpamPoolId(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val addressFamily: Option[zio.aws.ec2.model.AddressFamily] = scala
      .Option(impl.addressFamily())
      .map(value => zio.aws.ec2.model.AddressFamily.wrap(value))
    override val autoImport: Option[Boolean] =
      scala.Option(impl.autoImport()).map(value => value: Boolean)
    override val publiclyAdvertisable: Option[Boolean] =
      scala.Option(impl.publiclyAdvertisable()).map(value => value: Boolean)
    override val allocationMinNetmaskLength: Option[IpamNetmaskLength] = scala
      .Option(impl.allocationMinNetmaskLength())
      .map(value => zio.aws.ec2.model.primitives.IpamNetmaskLength(value))
    override val allocationMaxNetmaskLength: Option[IpamNetmaskLength] = scala
      .Option(impl.allocationMaxNetmaskLength())
      .map(value => zio.aws.ec2.model.primitives.IpamNetmaskLength(value))
    override val allocationDefaultNetmaskLength: Option[IpamNetmaskLength] =
      scala
        .Option(impl.allocationDefaultNetmaskLength())
        .map(value => zio.aws.ec2.model.primitives.IpamNetmaskLength(value))
    override val allocationResourceTags
        : Option[List[zio.aws.ec2.model.RequestIpamResourceTag.ReadOnly]] =
      scala
        .Option(impl.allocationResourceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.RequestIpamResourceTag.wrap(item)
          }.toList
        )
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val awsService: Option[zio.aws.ec2.model.IpamPoolAwsService] =
      scala
        .Option(impl.awsService())
        .map(value => zio.aws.ec2.model.IpamPoolAwsService.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateIpamPoolRequest
  ): zio.aws.ec2.model.CreateIpamPoolRequest.ReadOnly = new Wrapper(impl)
}
