package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CpuOptionsRequest(
    coreCount: Option[Integer] = None,
    threadsPerCore: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CpuOptionsRequest = {
    import CpuOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CpuOptionsRequest
      .builder()
      .optionallyWith(
        coreCount.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.coreCount)
      .optionallyWith(
        threadsPerCore.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.threadsPerCore)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CpuOptionsRequest.ReadOnly =
    zio.aws.ec2.model.CpuOptionsRequest.wrap(buildAwsValue())
}
object CpuOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CpuOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CpuOptionsRequest =
      zio.aws.ec2.model.CpuOptionsRequest(
        coreCount.map(value => value),
        threadsPerCore.map(value => value)
      )
    def coreCount: Option[Integer]
    def threadsPerCore: Option[Integer]
    def getCoreCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("coreCount", coreCount)
    def getThreadsPerCore: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("threadsPerCore", threadsPerCore)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CpuOptionsRequest
  ) extends zio.aws.ec2.model.CpuOptionsRequest.ReadOnly {
    override val coreCount: Option[Integer] = scala
      .Option(impl.coreCount())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val threadsPerCore: Option[Integer] = scala
      .Option(impl.threadsPerCore())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CpuOptionsRequest
  ): zio.aws.ec2.model.CpuOptionsRequest.ReadOnly = new Wrapper(impl)
}
