package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.KmsKeyId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CopySnapshotRequest(
    description: Option[String] = None,
    destinationOutpostArn: Option[String] = None,
    destinationRegion: Option[String] = None,
    encrypted: Option[Boolean] = None,
    kmsKeyId: Option[KmsKeyId] = None,
    presignedUrl: Option[String] = None,
    sourceRegion: String,
    sourceSnapshotId: String,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CopySnapshotRequest = {
    import CopySnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CopySnapshotRequest
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        destinationOutpostArn.map(value => value: java.lang.String)
      )(_.destinationOutpostArn)
      .optionallyWith(destinationRegion.map(value => value: java.lang.String))(
        _.destinationRegion
      )
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(presignedUrl.map(value => value: java.lang.String))(
        _.presignedUrl
      )
      .sourceRegion(sourceRegion: java.lang.String)
      .sourceSnapshotId(sourceSnapshotId: java.lang.String)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CopySnapshotRequest.ReadOnly =
    zio.aws.ec2.model.CopySnapshotRequest.wrap(buildAwsValue())
}
object CopySnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CopySnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CopySnapshotRequest =
      zio.aws.ec2.model.CopySnapshotRequest(
        description.map(value => value),
        destinationOutpostArn.map(value => value),
        destinationRegion.map(value => value),
        encrypted.map(value => value),
        kmsKeyId.map(value => value),
        presignedUrl.map(value => value),
        sourceRegion,
        sourceSnapshotId,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def description: Option[String]
    def destinationOutpostArn: Option[String]
    def destinationRegion: Option[String]
    def encrypted: Option[Boolean]
    def kmsKeyId: Option[KmsKeyId]
    def presignedUrl: Option[String]
    def sourceRegion: String
    def sourceSnapshotId: String
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDestinationOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationOutpostArn", destinationOutpostArn)
    def getDestinationRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationRegion", destinationRegion)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getPresignedUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("presignedUrl", presignedUrl)
    def getSourceRegion: ZIO[Any, Nothing, String] = ZIO.succeed(sourceRegion)
    def getSourceSnapshotId: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceSnapshotId)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CopySnapshotRequest
  ) extends zio.aws.ec2.model.CopySnapshotRequest.ReadOnly {
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val destinationOutpostArn: Option[String] =
      scala.Option(impl.destinationOutpostArn()).map(value => value: String)
    override val destinationRegion: Option[String] =
      scala.Option(impl.destinationRegion()).map(value => value: String)
    override val encrypted: Option[Boolean] =
      scala.Option(impl.encrypted()).map(value => value: Boolean)
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.ec2.model.primitives.KmsKeyId(value))
    override val presignedUrl: Option[String] =
      scala.Option(impl.presignedUrl()).map(value => value: String)
    override val sourceRegion: String = impl.sourceRegion(): String
    override val sourceSnapshotId: String = impl.sourceSnapshotId(): String
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CopySnapshotRequest
  ): zio.aws.ec2.model.CopySnapshotRequest.ReadOnly = new Wrapper(impl)
}
