package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClientLoginBannerResponseOptions(
    enabled: Option[Boolean] = None,
    bannerText: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ClientLoginBannerResponseOptions = {
    import ClientLoginBannerResponseOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ClientLoginBannerResponseOptions
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(bannerText.map(value => value: java.lang.String))(
        _.bannerText
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ClientLoginBannerResponseOptions.ReadOnly =
    zio.aws.ec2.model.ClientLoginBannerResponseOptions.wrap(buildAwsValue())
}
object ClientLoginBannerResponseOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ClientLoginBannerResponseOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ClientLoginBannerResponseOptions =
      zio.aws.ec2.model.ClientLoginBannerResponseOptions(
        enabled.map(value => value),
        bannerText.map(value => value)
      )
    def enabled: Option[Boolean]
    def bannerText: Option[String]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getBannerText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bannerText", bannerText)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ClientLoginBannerResponseOptions
  ) extends zio.aws.ec2.model.ClientLoginBannerResponseOptions.ReadOnly {
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
    override val bannerText: Option[String] =
      scala.Option(impl.bannerText()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ClientLoginBannerResponseOptions
  ): zio.aws.ec2.model.ClientLoginBannerResponseOptions.ReadOnly = new Wrapper(
    impl
  )
}
