package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait BootModeType {
  def unwrap: software.amazon.awssdk.services.ec2.model.BootModeType
}
object BootModeType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.BootModeType
  ): zio.aws.ec2.model.BootModeType = value match {
    case software.amazon.awssdk.services.ec2.model.BootModeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.BootModeType.LEGACY_BIOS =>
      val r = `legacy-bios`
      r
    case software.amazon.awssdk.services.ec2.model.BootModeType.UEFI =>
      val r = uefi
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.BootModeType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.BootModeType =
      software.amazon.awssdk.services.ec2.model.BootModeType.UNKNOWN_TO_SDK_VERSION
  }
  case object `legacy-bios` extends zio.aws.ec2.model.BootModeType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.BootModeType =
      software.amazon.awssdk.services.ec2.model.BootModeType.LEGACY_BIOS
  }
  case object uefi extends zio.aws.ec2.model.BootModeType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.BootModeType =
      software.amazon.awssdk.services.ec2.model.BootModeType.UEFI
  }
}
