package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait AvailabilityZoneState {
  def unwrap: software.amazon.awssdk.services.ec2.model.AvailabilityZoneState
}
object AvailabilityZoneState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.AvailabilityZoneState
  ): zio.aws.ec2.model.AvailabilityZoneState = value match {
    case software.amazon.awssdk.services.ec2.model.AvailabilityZoneState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.AvailabilityZoneState.AVAILABLE =>
      val r = available
      r
    case software.amazon.awssdk.services.ec2.model.AvailabilityZoneState.INFORMATION =>
      val r = information
      r
    case software.amazon.awssdk.services.ec2.model.AvailabilityZoneState.IMPAIRED =>
      val r = impaired
      r
    case software.amazon.awssdk.services.ec2.model.AvailabilityZoneState.UNAVAILABLE =>
      val r = unavailable
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.AvailabilityZoneState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AvailabilityZoneState =
      software.amazon.awssdk.services.ec2.model.AvailabilityZoneState.UNKNOWN_TO_SDK_VERSION
  }
  case object available extends zio.aws.ec2.model.AvailabilityZoneState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AvailabilityZoneState =
      software.amazon.awssdk.services.ec2.model.AvailabilityZoneState.AVAILABLE
  }
  case object information extends zio.aws.ec2.model.AvailabilityZoneState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AvailabilityZoneState =
      software.amazon.awssdk.services.ec2.model.AvailabilityZoneState.INFORMATION
  }
  case object impaired extends zio.aws.ec2.model.AvailabilityZoneState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AvailabilityZoneState =
      software.amazon.awssdk.services.ec2.model.AvailabilityZoneState.IMPAIRED
  }
  case object unavailable extends zio.aws.ec2.model.AvailabilityZoneState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AvailabilityZoneState =
      software.amazon.awssdk.services.ec2.model.AvailabilityZoneState.UNAVAILABLE
  }
}
