package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{DateTime, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class VgwTelemetry(
    acceptedRouteCount: Option[Integer] = None,
    lastStatusChange: Option[DateTime] = None,
    outsideIpAddress: Option[String] = None,
    status: Option[zio.aws.ec2.model.TelemetryStatus] = None,
    statusMessage: Option[String] = None,
    certificateArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VgwTelemetry = {
    import VgwTelemetry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VgwTelemetry
      .builder()
      .optionallyWith(
        acceptedRouteCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.acceptedRouteCount)
      .optionallyWith(
        lastStatusChange.map(value => DateTime.unwrap(value): Instant)
      )(_.lastStatusChange)
      .optionallyWith(outsideIpAddress.map(value => value: java.lang.String))(
        _.outsideIpAddress
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(certificateArn.map(value => value: java.lang.String))(
        _.certificateArn
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VgwTelemetry.ReadOnly =
    zio.aws.ec2.model.VgwTelemetry.wrap(buildAwsValue())
}
object VgwTelemetry {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.VgwTelemetry] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VgwTelemetry =
      zio.aws.ec2.model.VgwTelemetry(
        acceptedRouteCount.map(value => value),
        lastStatusChange.map(value => value),
        outsideIpAddress.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        certificateArn.map(value => value)
      )
    def acceptedRouteCount: Option[Integer]
    def lastStatusChange: Option[DateTime]
    def outsideIpAddress: Option[String]
    def status: Option[zio.aws.ec2.model.TelemetryStatus]
    def statusMessage: Option[String]
    def certificateArn: Option[String]
    def getAcceptedRouteCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("acceptedRouteCount", acceptedRouteCount)
    def getLastStatusChange: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastStatusChange", lastStatusChange)
    def getOutsideIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outsideIpAddress", outsideIpAddress)
    def getStatus: ZIO[Any, AwsError, zio.aws.ec2.model.TelemetryStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VgwTelemetry
  ) extends zio.aws.ec2.model.VgwTelemetry.ReadOnly {
    override val acceptedRouteCount: Option[Integer] = scala
      .Option(impl.acceptedRouteCount())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val lastStatusChange: Option[DateTime] = scala
      .Option(impl.lastStatusChange())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val outsideIpAddress: Option[String] =
      scala.Option(impl.outsideIpAddress()).map(value => value: String)
    override val status: Option[zio.aws.ec2.model.TelemetryStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.ec2.model.TelemetryStatus.wrap(value))
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val certificateArn: Option[String] =
      scala.Option(impl.certificateArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VgwTelemetry
  ): zio.aws.ec2.model.VgwTelemetry.ReadOnly = new Wrapper(impl)
}
