package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StaleIpPermission(
    fromPort: Option[Integer] = None,
    ipProtocol: Option[String] = None,
    ipRanges: Option[Iterable[String]] = None,
    prefixListIds: Option[Iterable[String]] = None,
    toPort: Option[Integer] = None,
    userIdGroupPairs: Option[Iterable[zio.aws.ec2.model.UserIdGroupPair]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.StaleIpPermission = {
    import StaleIpPermission.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.StaleIpPermission
      .builder()
      .optionallyWith(
        fromPort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.fromPort)
      .optionallyWith(ipProtocol.map(value => value: java.lang.String))(
        _.ipProtocol
      )
      .optionallyWith(
        ipRanges.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ipRanges)
      .optionallyWith(
        prefixListIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.prefixListIds)
      .optionallyWith(
        toPort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.toPort)
      .optionallyWith(
        userIdGroupPairs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userIdGroupPairs)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.StaleIpPermission.ReadOnly =
    zio.aws.ec2.model.StaleIpPermission.wrap(buildAwsValue())
}
object StaleIpPermission {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.StaleIpPermission
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.StaleIpPermission =
      zio.aws.ec2.model.StaleIpPermission(
        fromPort.map(value => value),
        ipProtocol.map(value => value),
        ipRanges.map(value => value),
        prefixListIds.map(value => value),
        toPort.map(value => value),
        userIdGroupPairs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def fromPort: Option[Integer]
    def ipProtocol: Option[String]
    def ipRanges: Option[List[String]]
    def prefixListIds: Option[List[String]]
    def toPort: Option[Integer]
    def userIdGroupPairs
        : Option[List[zio.aws.ec2.model.UserIdGroupPair.ReadOnly]]
    def getFromPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getIpProtocol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipProtocol", ipProtocol)
    def getIpRanges: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("ipRanges", ipRanges)
    def getPrefixListIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("prefixListIds", prefixListIds)
    def getToPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("toPort", toPort)
    def getUserIdGroupPairs
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.UserIdGroupPair.ReadOnly]] =
      AwsError.unwrapOptionField("userIdGroupPairs", userIdGroupPairs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.StaleIpPermission
  ) extends zio.aws.ec2.model.StaleIpPermission.ReadOnly {
    override val fromPort: Option[Integer] = scala
      .Option(impl.fromPort())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val ipProtocol: Option[String] =
      scala.Option(impl.ipProtocol()).map(value => value: String)
    override val ipRanges: Option[List[String]] = scala
      .Option(impl.ipRanges())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val prefixListIds: Option[List[String]] = scala
      .Option(impl.prefixListIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val toPort: Option[Integer] = scala
      .Option(impl.toPort())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val userIdGroupPairs
        : Option[List[zio.aws.ec2.model.UserIdGroupPair.ReadOnly]] = scala
      .Option(impl.userIdGroupPairs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.UserIdGroupPair.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.StaleIpPermission
  ): zio.aws.ec2.model.StaleIpPermission.ReadOnly = new Wrapper(impl)
}
