package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SpotOptionsRequest(
    allocationStrategy: Option[zio.aws.ec2.model.SpotAllocationStrategy] = None,
    maintenanceStrategies: Option[
      zio.aws.ec2.model.FleetSpotMaintenanceStrategiesRequest
    ] = None,
    instanceInterruptionBehavior: Option[
      zio.aws.ec2.model.SpotInstanceInterruptionBehavior
    ] = None,
    instancePoolsToUseCount: Option[Integer] = None,
    singleInstanceType: Option[Boolean] = None,
    singleAvailabilityZone: Option[Boolean] = None,
    minTargetCapacity: Option[Integer] = None,
    maxTotalPrice: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SpotOptionsRequest = {
    import SpotOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SpotOptionsRequest
      .builder()
      .optionallyWith(allocationStrategy.map(value => value.unwrap))(
        _.allocationStrategy
      )
      .optionallyWith(
        maintenanceStrategies.map(value => value.buildAwsValue())
      )(_.maintenanceStrategies)
      .optionallyWith(instanceInterruptionBehavior.map(value => value.unwrap))(
        _.instanceInterruptionBehavior
      )
      .optionallyWith(
        instancePoolsToUseCount.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.instancePoolsToUseCount)
      .optionallyWith(
        singleInstanceType.map(value => value: java.lang.Boolean)
      )(_.singleInstanceType)
      .optionallyWith(
        singleAvailabilityZone.map(value => value: java.lang.Boolean)
      )(_.singleAvailabilityZone)
      .optionallyWith(
        minTargetCapacity.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.minTargetCapacity)
      .optionallyWith(maxTotalPrice.map(value => value: java.lang.String))(
        _.maxTotalPrice
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SpotOptionsRequest.ReadOnly =
    zio.aws.ec2.model.SpotOptionsRequest.wrap(buildAwsValue())
}
object SpotOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SpotOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SpotOptionsRequest =
      zio.aws.ec2.model.SpotOptionsRequest(
        allocationStrategy.map(value => value),
        maintenanceStrategies.map(value => value.asEditable),
        instanceInterruptionBehavior.map(value => value),
        instancePoolsToUseCount.map(value => value),
        singleInstanceType.map(value => value),
        singleAvailabilityZone.map(value => value),
        minTargetCapacity.map(value => value),
        maxTotalPrice.map(value => value)
      )
    def allocationStrategy: Option[zio.aws.ec2.model.SpotAllocationStrategy]
    def maintenanceStrategies: Option[
      zio.aws.ec2.model.FleetSpotMaintenanceStrategiesRequest.ReadOnly
    ]
    def instanceInterruptionBehavior
        : Option[zio.aws.ec2.model.SpotInstanceInterruptionBehavior]
    def instancePoolsToUseCount: Option[Integer]
    def singleInstanceType: Option[Boolean]
    def singleAvailabilityZone: Option[Boolean]
    def minTargetCapacity: Option[Integer]
    def maxTotalPrice: Option[String]
    def getAllocationStrategy
        : ZIO[Any, AwsError, zio.aws.ec2.model.SpotAllocationStrategy] =
      AwsError.unwrapOptionField("allocationStrategy", allocationStrategy)
    def getMaintenanceStrategies: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FleetSpotMaintenanceStrategiesRequest.ReadOnly
    ] =
      AwsError.unwrapOptionField("maintenanceStrategies", maintenanceStrategies)
    def getInstanceInterruptionBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.SpotInstanceInterruptionBehavior
    ] = AwsError.unwrapOptionField(
      "instanceInterruptionBehavior",
      instanceInterruptionBehavior
    )
    def getInstancePoolsToUseCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("instancePoolsToUseCount", instancePoolsToUseCount)
    def getSingleInstanceType: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("singleInstanceType", singleInstanceType)
    def getSingleAvailabilityZone: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("singleAvailabilityZone", singleAvailabilityZone)
    def getMinTargetCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("minTargetCapacity", minTargetCapacity)
    def getMaxTotalPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxTotalPrice", maxTotalPrice)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SpotOptionsRequest
  ) extends zio.aws.ec2.model.SpotOptionsRequest.ReadOnly {
    override val allocationStrategy
        : Option[zio.aws.ec2.model.SpotAllocationStrategy] = scala
      .Option(impl.allocationStrategy())
      .map(value => zio.aws.ec2.model.SpotAllocationStrategy.wrap(value))
    override val maintenanceStrategies: Option[
      zio.aws.ec2.model.FleetSpotMaintenanceStrategiesRequest.ReadOnly
    ] = scala
      .Option(impl.maintenanceStrategies())
      .map(value =>
        zio.aws.ec2.model.FleetSpotMaintenanceStrategiesRequest.wrap(value)
      )
    override val instanceInterruptionBehavior
        : Option[zio.aws.ec2.model.SpotInstanceInterruptionBehavior] = scala
      .Option(impl.instanceInterruptionBehavior())
      .map(value =>
        zio.aws.ec2.model.SpotInstanceInterruptionBehavior.wrap(value)
      )
    override val instancePoolsToUseCount: Option[Integer] = scala
      .Option(impl.instancePoolsToUseCount())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val singleInstanceType: Option[Boolean] =
      scala.Option(impl.singleInstanceType()).map(value => value: Boolean)
    override val singleAvailabilityZone: Option[Boolean] =
      scala.Option(impl.singleAvailabilityZone()).map(value => value: Boolean)
    override val minTargetCapacity: Option[Integer] = scala
      .Option(impl.minTargetCapacity())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val maxTotalPrice: Option[String] =
      scala.Option(impl.maxTotalPrice()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SpotOptionsRequest
  ): zio.aws.ec2.model.SpotOptionsRequest.ReadOnly = new Wrapper(impl)
}
