package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, MillisecondDateTime}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class RestoreSnapshotFromRecycleBinResponse(
    snapshotId: Option[String] = None,
    outpostArn: Option[String] = None,
    description: Option[String] = None,
    encrypted: Option[Boolean] = None,
    ownerId: Option[String] = None,
    progress: Option[String] = None,
    startTime: Option[MillisecondDateTime] = None,
    state: Option[zio.aws.ec2.model.SnapshotState] = None,
    volumeId: Option[String] = None,
    volumeSize: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinResponse = {
    import RestoreSnapshotFromRecycleBinResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinResponse
      .builder()
      .optionallyWith(snapshotId.map(value => value: java.lang.String))(
        _.snapshotId
      )
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(progress.map(value => value: java.lang.String))(
        _.progress
      )
      .optionallyWith(
        startTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(volumeId.map(value => value: java.lang.String))(
        _.volumeId
      )
      .optionallyWith(
        volumeSize.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.volumeSize)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RestoreSnapshotFromRecycleBinResponse.ReadOnly =
    zio.aws.ec2.model.RestoreSnapshotFromRecycleBinResponse
      .wrap(buildAwsValue())
}
object RestoreSnapshotFromRecycleBinResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RestoreSnapshotFromRecycleBinResponse =
      zio.aws.ec2.model.RestoreSnapshotFromRecycleBinResponse(
        snapshotId.map(value => value),
        outpostArn.map(value => value),
        description.map(value => value),
        encrypted.map(value => value),
        ownerId.map(value => value),
        progress.map(value => value),
        startTime.map(value => value),
        state.map(value => value),
        volumeId.map(value => value),
        volumeSize.map(value => value)
      )
    def snapshotId: Option[String]
    def outpostArn: Option[String]
    def description: Option[String]
    def encrypted: Option[Boolean]
    def ownerId: Option[String]
    def progress: Option[String]
    def startTime: Option[MillisecondDateTime]
    def state: Option[zio.aws.ec2.model.SnapshotState]
    def volumeId: Option[String]
    def volumeSize: Option[Integer]
    def getSnapshotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getProgress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("progress", progress)
    def getStartTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.SnapshotState] =
      AwsError.unwrapOptionField("state", state)
    def getVolumeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getVolumeSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("volumeSize", volumeSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinResponse
  ) extends zio.aws.ec2.model.RestoreSnapshotFromRecycleBinResponse.ReadOnly {
    override val snapshotId: Option[String] =
      scala.Option(impl.snapshotId()).map(value => value: String)
    override val outpostArn: Option[String] =
      scala.Option(impl.outpostArn()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val encrypted: Option[Boolean] =
      scala.Option(impl.encrypted()).map(value => value: Boolean)
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val progress: Option[String] =
      scala.Option(impl.progress()).map(value => value: String)
    override val startTime: Option[MillisecondDateTime] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val state: Option[zio.aws.ec2.model.SnapshotState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.SnapshotState.wrap(value))
    override val volumeId: Option[String] =
      scala.Option(impl.volumeId()).map(value => value: String)
    override val volumeSize: Option[Integer] = scala
      .Option(impl.volumeSize())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RestoreSnapshotFromRecycleBinResponse
  ): zio.aws.ec2.model.RestoreSnapshotFromRecycleBinResponse.ReadOnly =
    new Wrapper(impl)
}
