package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PurchaseScheduledInstancesResponse(
    scheduledInstanceSet: Option[
      Iterable[zio.aws.ec2.model.ScheduledInstance]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PurchaseScheduledInstancesResponse = {
    import PurchaseScheduledInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PurchaseScheduledInstancesResponse
      .builder()
      .optionallyWith(
        scheduledInstanceSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scheduledInstanceSet)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.PurchaseScheduledInstancesResponse.ReadOnly =
    zio.aws.ec2.model.PurchaseScheduledInstancesResponse.wrap(buildAwsValue())
}
object PurchaseScheduledInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PurchaseScheduledInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PurchaseScheduledInstancesResponse =
      zio.aws.ec2.model.PurchaseScheduledInstancesResponse(
        scheduledInstanceSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def scheduledInstanceSet
        : Option[List[zio.aws.ec2.model.ScheduledInstance.ReadOnly]]
    def getScheduledInstanceSet: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ScheduledInstance.ReadOnly
    ]] =
      AwsError.unwrapOptionField("scheduledInstanceSet", scheduledInstanceSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PurchaseScheduledInstancesResponse
  ) extends zio.aws.ec2.model.PurchaseScheduledInstancesResponse.ReadOnly {
    override val scheduledInstanceSet
        : Option[List[zio.aws.ec2.model.ScheduledInstance.ReadOnly]] = scala
      .Option(impl.scheduledInstanceSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ScheduledInstance.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PurchaseScheduledInstancesResponse
  ): zio.aws.ec2.model.PurchaseScheduledInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
