package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PurchaseHostReservationResponse(
    clientToken: Option[String] = None,
    currencyCode: Option[zio.aws.ec2.model.CurrencyCodeValues] = None,
    purchase: Option[Iterable[zio.aws.ec2.model.Purchase]] = None,
    totalHourlyPrice: Option[String] = None,
    totalUpfrontPrice: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PurchaseHostReservationResponse = {
    import PurchaseHostReservationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PurchaseHostReservationResponse
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(currencyCode.map(value => value.unwrap))(_.currencyCode)
      .optionallyWith(
        purchase.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.purchase)
      .optionallyWith(totalHourlyPrice.map(value => value: java.lang.String))(
        _.totalHourlyPrice
      )
      .optionallyWith(totalUpfrontPrice.map(value => value: java.lang.String))(
        _.totalUpfrontPrice
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PurchaseHostReservationResponse.ReadOnly =
    zio.aws.ec2.model.PurchaseHostReservationResponse.wrap(buildAwsValue())
}
object PurchaseHostReservationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PurchaseHostReservationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PurchaseHostReservationResponse =
      zio.aws.ec2.model.PurchaseHostReservationResponse(
        clientToken.map(value => value),
        currencyCode.map(value => value),
        purchase.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        totalHourlyPrice.map(value => value),
        totalUpfrontPrice.map(value => value)
      )
    def clientToken: Option[String]
    def currencyCode: Option[zio.aws.ec2.model.CurrencyCodeValues]
    def purchase: Option[List[zio.aws.ec2.model.Purchase.ReadOnly]]
    def totalHourlyPrice: Option[String]
    def totalUpfrontPrice: Option[String]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCurrencyCode
        : ZIO[Any, AwsError, zio.aws.ec2.model.CurrencyCodeValues] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getPurchase
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Purchase.ReadOnly]] =
      AwsError.unwrapOptionField("purchase", purchase)
    def getTotalHourlyPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("totalHourlyPrice", totalHourlyPrice)
    def getTotalUpfrontPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("totalUpfrontPrice", totalUpfrontPrice)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PurchaseHostReservationResponse
  ) extends zio.aws.ec2.model.PurchaseHostReservationResponse.ReadOnly {
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val currencyCode: Option[zio.aws.ec2.model.CurrencyCodeValues] =
      scala
        .Option(impl.currencyCode())
        .map(value => zio.aws.ec2.model.CurrencyCodeValues.wrap(value))
    override val purchase: Option[List[zio.aws.ec2.model.Purchase.ReadOnly]] =
      scala
        .Option(impl.purchase())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Purchase.wrap(item)
          }.toList
        )
    override val totalHourlyPrice: Option[String] =
      scala.Option(impl.totalHourlyPrice()).map(value => value: String)
    override val totalUpfrontPrice: Option[String] =
      scala.Option(impl.totalUpfrontPrice()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PurchaseHostReservationResponse
  ): zio.aws.ec2.model.PurchaseHostReservationResponse.ReadOnly = new Wrapper(
    impl
  )
}
