package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.FleetId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyFleetRequest(
    excessCapacityTerminationPolicy: Option[
      zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy
    ] = None,
    launchTemplateConfigs: Option[
      Iterable[zio.aws.ec2.model.FleetLaunchTemplateConfigRequest]
    ] = None,
    fleetId: FleetId,
    targetCapacitySpecification: Option[
      zio.aws.ec2.model.TargetCapacitySpecificationRequest
    ] = None,
    context: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyFleetRequest = {
    import ModifyFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyFleetRequest
      .builder()
      .optionallyWith(
        excessCapacityTerminationPolicy.map(value => value.unwrap)
      )(_.excessCapacityTerminationPolicy)
      .optionallyWith(
        launchTemplateConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.launchTemplateConfigs)
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .optionallyWith(
        targetCapacitySpecification.map(value => value.buildAwsValue())
      )(_.targetCapacitySpecification)
      .optionallyWith(context.map(value => value: java.lang.String))(_.context)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyFleetRequest.ReadOnly =
    zio.aws.ec2.model.ModifyFleetRequest.wrap(buildAwsValue())
}
object ModifyFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyFleetRequest =
      zio.aws.ec2.model.ModifyFleetRequest(
        excessCapacityTerminationPolicy.map(value => value),
        launchTemplateConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        fleetId,
        targetCapacitySpecification.map(value => value.asEditable),
        context.map(value => value)
      )
    def excessCapacityTerminationPolicy
        : Option[zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy]
    def launchTemplateConfigs: Option[
      List[zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.ReadOnly]
    ]
    def fleetId: FleetId
    def targetCapacitySpecification
        : Option[zio.aws.ec2.model.TargetCapacitySpecificationRequest.ReadOnly]
    def context: Option[String]
    def getExcessCapacityTerminationPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy
    ] = AwsError.unwrapOptionField(
      "excessCapacityTerminationPolicy",
      excessCapacityTerminationPolicy
    )
    def getLaunchTemplateConfigs: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.ReadOnly
    ]] =
      AwsError.unwrapOptionField("launchTemplateConfigs", launchTemplateConfigs)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getTargetCapacitySpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TargetCapacitySpecificationRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "targetCapacitySpecification",
      targetCapacitySpecification
    )
    def getContext: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("context", context)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyFleetRequest
  ) extends zio.aws.ec2.model.ModifyFleetRequest.ReadOnly {
    override val excessCapacityTerminationPolicy
        : Option[zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy] = scala
      .Option(impl.excessCapacityTerminationPolicy())
      .map(value =>
        zio.aws.ec2.model.FleetExcessCapacityTerminationPolicy.wrap(value)
      )
    override val launchTemplateConfigs: Option[
      List[zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.ReadOnly]
    ] = scala
      .Option(impl.launchTemplateConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.FleetLaunchTemplateConfigRequest.wrap(item)
        }.toList
      )
    override val fleetId: FleetId =
      zio.aws.ec2.model.primitives.FleetId(impl.fleetId())
    override val targetCapacitySpecification: Option[
      zio.aws.ec2.model.TargetCapacitySpecificationRequest.ReadOnly
    ] = scala
      .Option(impl.targetCapacitySpecification())
      .map(value =>
        zio.aws.ec2.model.TargetCapacitySpecificationRequest.wrap(value)
      )
    override val context: Option[String] =
      scala.Option(impl.context()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyFleetRequest
  ): zio.aws.ec2.model.ModifyFleetRequest.ReadOnly = new Wrapper(impl)
}
